#include "wpnew.h"
#include "ui_wpnew.h"
#include "wpmanager.h"
#include "ui_wpmanager.h"
#include "wallpaeper.h"
#include "ui_wallpaeper.h"

wallPaeper::wallPaeper(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::wallPaeper)
{
    ui->setupUi(this);
    this->setAttribute(Qt::WA_Maemo5StackedWindow);

    abtDialogExists = false;
    setupWPMenuBar();

    connect(ui->newBtn, SIGNAL(clicked()),
            this, SLOT(newBtnClicked()));
    connect(ui->manBtn, SIGNAL(clicked()),
            this, SLOT(manBtnClicked()));

    openNewWin = true;
    openManWin = true;
}





wallPaeper::~wallPaeper()
{
    delete ui;
}





void wallPaeper::newBtnClicked() {
    if(openNewWin == true) {
        openNewWin = false;
        openManWin = false;

        newWin = new wpNew(this);
        newWin->setAttribute(Qt::WA_Maemo5StackedWindow);
        newWin->setAttribute(Qt::WA_DeleteOnClose);

        connect(newWin, SIGNAL(destroyed()),
                this, SLOT(openWinTrue()));

        newWin->show();
    }
}





void wallPaeper::manBtnClicked() {
    if(openManWin == true) {
        openNewWin = false;
        openManWin = false;

        manWin = new wpManager(this);
        manWin->setAttribute(Qt::WA_Maemo5StackedWindow);
        manWin->setAttribute(Qt::WA_DeleteOnClose);

        connect(manWin, SIGNAL(destroyed()),
                this, SLOT(openWinTrue()));

        manWin->show();
    }
}





void wallPaeper::openWinTrue() {
    openNewWin = true;
    openManWin = true;
}





void wallPaeper::setupWPMenuBar() {
    wpMenuActionAbout = new QAction(tr("About..."), this);

    wpMenu = menuBar()->addMenu("");
    wpMenu->addAction(wpMenuActionAbout);

    connect(wpMenuActionAbout, SIGNAL(triggered()),
            this, SLOT(createAbtDialog()));
}





void wallPaeper::createAbtDialog() {
    // Only create a new dialog if it hasn't been made yet
    if(abtDialogExists == false) {
        abtDialog = new aboutDialog(this);
        abtDialog->setWindowTitle("Wallpaeper 0.4.2 for Nokia N900");

        abtDialog->ui->aboutText1->adjustSize();
        abtDialog->ui->aboutText2->adjustSize();

        connect(abtDialog->ui->aboutBtnBox, SIGNAL(accepted()),
                this->abtDialog, SLOT(close()));

        abtDialog->adjustSize();
    }
    abtDialog->show();
}
