#ifndef WPMANAGER_H
#define WPMANAGER_H

#include "fourimages.h"
#include "ui_fourimages.h"
#include "deletedialog.h"
#include "ui_deletedialog.h"

#include <QMainWindow>
#include <QDir>
#include <QLabel>
#include <QPushButton>
#include <QListWidgetItem>

namespace Ui {
    class wpManager;
}

class wpManager : public QMainWindow
{
    Q_OBJECT

public:
    explicit wpManager(QWidget *parent = 0);
    ~wpManager();

public slots:
    void confirmDelSet();
    void delSet();
    void updatePrevs();
    void itemChanged();
    void editCurrent();
    void updateListAfterEdit();

private:
    Ui::wpManager *ui;

    /************ FUNCTIONS **************/
    void updateList();
    void changeCurItem(QListWidgetItem*,QListWidgetItem*);

    /************ VARIABLES **************/
    int i;

    QList<QLabel*> manPrev;

    QDir imageSetDir;
    QStringList nameFilters;
    QStringList imageSetList;
    QList<QListWidgetItem*> itemList;

    QString delFileName;
    QFile delFileWithPath;
    deleteDialog* delDialog;
    bool delDialogIsMade;

    QFile imageSetPrev;
    QString lineInFile;

    fourImages* editWin;
    QFile editFile;

    int curRowBeforeEdit;
};

#endif // WPMANAGER_H
