/* maemo vpnc-gui
 * 
 * Copyright (c) 2007 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

/* IMPORTS */
#include <gtk/gtk.h>
#include <string.h>

#include "hildon.h"
#include "profile.h"
#include "config_data_vpnc.h"
#include "profiles_gui.h"
#include "pcf_import.h"
#include "profiles_gui_vpnc.h"

/* (local) VARIABLES */

enum {
  CONF_IMPORT_PCF,
  CONF_SAVE,
  CONF_CANCEL
};

static GtkWidget *xauth_user;
static GtkWidget *xauth_pw;

static GtkWidget *ipsec_gw;
static GtkWidget *ipsec_id;
static GtkWidget *ipsec_secret;

static GtkWidget *domain;

static GtkWidget *interactive;

static struct profile *prof=NULL;

static void profiles_gui_vpnc_interactive_toggle(GtkToggleButton *togglebutton,
		                            gpointer user_data) {

	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(interactive))) {
		gtk_widget_set_sensitive(xauth_pw, FALSE);
	}
	else {
                gtk_widget_set_sensitive(xauth_pw, TRUE);
	}
	
}

static gchar *create_from_entry(GtkEntry *e) {

    const gchar *text;
    text=gtk_entry_get_text(e);
    if(strlen(text) > 0)
	    return g_strdup(text);
    return NULL;
}

static void profiles_gui_vpnc_new_response_cb(GtkDialog *window,
				      gint response,
				      gpointer data) {

  GtkWidget *dialog;

  switch (response) {

  case CONF_IMPORT_PCF:

    dialog=
      hildon_file_chooser_dialog_new(GTK_WINDOW(window),
				     GTK_FILE_CHOOSER_ACTION_OPEN);

    if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK) {
	    if(prof->config_data==NULL)
		    prof->config_data=config_data_vpnc_alloc();

	    pcf_import_file(gtk_file_chooser_get_filename(
				    GTK_FILE_CHOOSER(dialog)),
			    prof->config_data);
	    /* close current dialog and create a new one to show
	     * imported values */
	    gtk_widget_destroy(dialog);
	    gtk_widget_destroy(GTK_WIDGET(window));
	    profiles_gui_vpnc_edit(prof);
    }
    else {
	    gtk_widget_destroy(dialog);
    }



    break;

  case CONF_SAVE: {

    prof->type=PROFILE_TYPE_VPNC;
    config_data_vpnc *conf=config_data_vpnc_alloc();

    conf->xauth_interactive=gtk_toggle_button_get_active(
		    GTK_TOGGLE_BUTTON(interactive));
    
    conf->ipsec_gw=create_from_entry(GTK_ENTRY(ipsec_gw));
    conf->ipsec_id=create_from_entry(GTK_ENTRY(ipsec_id));
    conf->ipsec_secret=create_from_entry(GTK_ENTRY(ipsec_secret));

    if(!conf->xauth_interactive)
    	conf->xauth_pw=create_from_entry(GTK_ENTRY(xauth_pw));
    else {
	    if(conf->xauth_pw!=NULL)
		    g_free(conf->xauth_pw);
	    conf->xauth_pw=NULL;
    }
    conf->xauth_user=create_from_entry(GTK_ENTRY(xauth_user));
    conf->domain=create_from_entry(GTK_ENTRY(domain));


    prof->config_data=conf;
    
    if(!profiles_gui_save_profile(prof)) {
	    // TODO: sure to free here? chould be quite DANGEROUS!!
	    config_data_vpnc_free(prof->config_data);
	    profile_free(prof);
	    prof=NULL;

	    /* error dialog is in profiles_gui */
	    
	    break; /* couldn't be saved */
    }
    
    /* fall through to next ... */
		  }
  case CONF_CANCEL:
    gtk_widget_destroy(GTK_WIDGET(window));
  }

}

/* EXPORTS */

/**
 * Show dialog to edit vpnc-configuration data of specified profile
 * @param p the profile
 */
void profiles_gui_vpnc_edit(struct profile *p) {

  /* set profile */
  prof=p;

  GtkWidget *table;
  GtkWidget *window;

  window = gtk_dialog_new_with_buttons("Configuration",
				       NULL,
				       GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR,
				       "Import PCF",
				       CONF_IMPORT_PCF,
				       "Save",
				       CONF_SAVE,
				       "Cancel",
				       CONF_CANCEL,
				       NULL);

  /* create entries */
  xauth_user=gtk_entry_new();
  xauth_pw=gtk_entry_new();
  gtk_entry_set_visibility(GTK_ENTRY(xauth_pw), FALSE);
  ipsec_gw=gtk_entry_new();
  ipsec_id=gtk_entry_new();
  ipsec_secret=gtk_entry_new();
  gtk_entry_set_visibility(GTK_ENTRY(ipsec_secret), FALSE);
  domain=gtk_entry_new();
  interactive=gtk_check_button_new_with_label("Use interactive auth");

  /* fill entries */
  config_data_vpnc *d=prof->config_data;
  if(d!=NULL) {
	  if(d->xauth_user!=NULL)
		  gtk_entry_set_text(GTK_ENTRY(xauth_user), d->xauth_user);
	  if(d->xauth_pw!=NULL)
		  gtk_entry_set_text(GTK_ENTRY(xauth_pw), d->xauth_pw);
	  if(d->ipsec_gw!=NULL)
		  gtk_entry_set_text(GTK_ENTRY(ipsec_gw), d->ipsec_gw);
	  if(d->ipsec_id!=NULL)
		  gtk_entry_set_text(GTK_ENTRY(ipsec_id), d->ipsec_id);
	  if(d->ipsec_secret!=NULL)
		  gtk_entry_set_text(GTK_ENTRY(ipsec_secret), d->ipsec_secret);
	  if(d->domain!=NULL)
		  gtk_entry_set_text(GTK_ENTRY(domain), d->domain)
			  ;
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(interactive),
			  d->xauth_interactive);
	  /* simulate toglled event */
	  profiles_gui_vpnc_interactive_toggle(GTK_TOGGLE_BUTTON(interactive),
			 NULL);
	  
  }
  table=gtk_table_new(10,
                      2,
                      FALSE);

  
  gtk_table_attach_defaults(GTK_TABLE(table),
			    gtk_label_new("Gateway"),
			    0, 1, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table),
			    ipsec_gw,
			    1, 2, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table),
			    gtk_label_new("Group-Name"),
			    0, 1, 1, 2);

  gtk_table_attach_defaults(GTK_TABLE(table),
			    ipsec_id,
			    1, 2, 1, 2);


  gtk_table_attach_defaults(GTK_TABLE(table),
			    gtk_label_new("Group-PW"),
			    0, 1, 2, 3);

  gtk_table_attach_defaults(GTK_TABLE(table),
			    ipsec_secret,
			    1, 2, 2, 3);


  gtk_table_attach_defaults(GTK_TABLE(table),
			    gtk_label_new("Username"),
			    0, 1, 3, 4);

  gtk_table_attach_defaults(GTK_TABLE(table),
			    xauth_user,
			    1, 2, 3, 4);


  gtk_table_attach_defaults(GTK_TABLE(table),
		  interactive,
		  0, 2, 4, 5);


  gtk_table_attach_defaults(GTK_TABLE(table),
			    gtk_label_new("Password"),
			    0, 1, 5, 6);
  
  

  gtk_table_attach_defaults(GTK_TABLE(table),
			    xauth_pw,
			    1, 2, 5, 6);



  gtk_table_attach_defaults(GTK_TABLE(table),
			    gtk_label_new("Domain"),
			    0, 1, 6, 7);

  gtk_table_attach_defaults(GTK_TABLE(table),
			    domain,
			    1, 2, 6, 7);


  gtk_box_pack_end(GTK_BOX(GTK_DIALOG(window)->vbox), table, TRUE, TRUE, 0);

 
  g_signal_connect(G_OBJECT(interactive),
		  "toggled",
		  G_CALLBACK(profiles_gui_vpnc_interactive_toggle), NULL); 
  
  g_signal_connect(G_OBJECT(window),
                   "response",
		   G_CALLBACK(profiles_gui_vpnc_new_response_cb), NULL);
  

  gtk_widget_show_all(window);

}

/**
 * Show dialog to create new vpnc-profile with specified name.
 * No references to name are kept.
 * @param name pointer to String containing the name, no references are kept
 */
void profiles_gui_vpnc_new(gchar *name) {

	struct profile *p=profile_alloc();
	p->name=g_strdup(name);
	p->config_data=NULL;
	
	profiles_gui_vpnc_edit(p);

}
