/* maemo vpnc-gui
 * 
 * Copyright (c) 2007-2008 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

/* IMPORTS */
#define _GNU_SOURCE
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <pwd.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>
#include <glib.h>

#include "profile.h"
#include "config_data_openvpn.h"
#include "fileaccess_openvpn.h"

/* EXPORTS */

/**
 * Load openvpn-configuration from specified file.
 * This function does not manipulate path.
 * Result must be freed if not longer used.
 * 
 * @param path pointer to a string containing the path
 * @return freshly g_alloced config_data_openvpn with parsed config-values
 *         or NULL in case of an error
 */
config_data_openvpn *fileaccess_openvpn_load_file(char *path) {

	config_data_openvpn *data = config_data_openvpn_alloc();

	FILE *fp=fopen(path, "r");
	if(fp==NULL) {
		perror("fopen failed");
		return NULL;
	}


	char *line = NULL;
	size_t line_length = 0;


	for(;;) {
		ssize_t llen;

		llen = getline(&line, &line_length, fp);
		if (llen == -1 && feof(fp))
			break;
		if (llen == -1) {
			perror("getline failed");
			break;
		}

		if(line[0]=='#')
			continue;

		/* strip \n */
		line[llen-1]='\0';

#ifdef DEBUG
		printf("line: '%s'\n", line);
#endif

		//if(strstr(line, "IPSec gateway ")==line) {
		//	data->ipsec_gw=g_strdup(line+sizeof("IPSec gateway"));
		//}
	}

	if(line!=NULL)
		free(line);


	return data;

}

/**
 * Write openvpn config-data to specified file.
 * This function does not manipulate path or data.
 * 
 * @param path a pointer to a string containing the path
 * @param data the configuration data, NULL items will not be written
 * @return TRUE if data has been successfully written
 */
gboolean fileaccess_openvpn_save_file(char *path, config_data_openvpn *data) {

	FILE *fp=fopen(path, "w");
	if(fp==NULL) {
		perror("fopen failed");
		return FALSE;
	}


	fprintf(fp, "# Generated by maemo vpnc-gui\n");
	fprintf(fp, "# Michael 'ScriptKiller' Arndt <scriptkiller@gmx.de>\n");
	fprintf(fp, "# DON'T EDIT BY HAND (unless u really know what u're doing)\n\n");


	//if(data->ipsec_gw)
	//	fprintf(fp, "IPSec gateway %s\n", data->ipsec_gw);

	fclose(fp);

#ifdef DEBUG
	puts("Config written");
#endif

	return TRUE;
}
