/* maemo vpnc-gui
 * 
 * Copyright (c) 2007 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

/* IMPORTS */
#include <glib.h>

#include "config_data_vpnc.h"

/* EXPORTS */

/**
 * Allocate memory for new configuration data, aborts program if
 * allocation fails. In configuration data all pointers are set to NULL.
 *
 * @return pointer to allocated memory
 */
config_data_vpnc *config_data_vpnc_alloc() {
	config_data_vpnc *ret=g_malloc(sizeof(config_data_vpnc));
	ret->xauth_user=NULL;
	ret->xauth_pw=NULL;
	ret->ipsec_gw=NULL;
	ret->ipsec_id=NULL;
	ret->ipsec_secret=NULL;
	ret->domain=NULL;
	ret->xauth_interactive=FALSE;
	
	return ret;
}

/**
 * Free memory of specified configuration data, also tries
 * to free all members of struct
 *
 * @param c the configuration-data
 */
void config_data_vpnc_free(config_data_vpnc *c) {
	if(c->xauth_user)
		g_free(c->xauth_user);
	if(c->xauth_pw)
		g_free(c->xauth_pw);
	if(c->ipsec_gw)
		g_free(c->ipsec_gw);
	if(c->ipsec_id)
		g_free(c->ipsec_id);
	if(c->ipsec_secret)
		g_free(c->ipsec_secret);
	if(c->domain)
		g_free(c->domain);

	g_free(c);
}
