#include "widgetmanager.h"
#include "settings.h"
#include "desktopwidget.h"

WidgetManager::WidgetManager(QObject *parent) :
    QObject(parent)
{
}

void WidgetManager::RestoreWidgets()
{
    QList<QString> appletIds = Settings::GetAppletIds();

    if (appletIds.count() > 0){
        //Restore widgets:
        foreach(QString id, appletIds){
            DesktopWidget* w = new DesktopWidget(NULL, id);
            w->show();
        }
    }else{
        //Create new widget:
        DesktopWidget* w = new DesktopWidget(NULL, "");
        appletIds.append(w->GetAppletId());
        w->show();
    }
    Settings::SaveAppletIds(appletIds);
}

void WidgetManager::receiveMessage(const QString& message)
{
    qDebug() << QString("Received message: %1").arg(message);
    if (message == MESSAGE_ADD_WIDGET){
        //Create new widget:
        QList<QString> appletIds = Settings::GetAppletIds();
        DesktopWidget* w = new DesktopWidget(NULL, "");
        appletIds.append(w->GetAppletId());
        w->show();
        Settings::SaveAppletIds(appletIds);
    }
}

void WidgetManager::RemoveWidget(QString appletId)
{
    qDebug() << QString("Removing widget: %1").arg(appletId);
    Settings::RemoveWidget(appletId);
}
