/*
@version: 0.4
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License
*/

#include "telepathyutility.h"
#include <QDebug>
#include <QDBusMetaType>

int main(int argc, char *argv[])
{
    qDBusRegisterMetaType<org::freedesktop::Telepathy::SimplePresence>();

    TelepathyUtility *tpUtility = new TelepathyUtility();

    if (argc > 1 && argv[1]){
        QString instruction = QString(argv[1]);
        if (instruction == "INSTALL"){
            //Check if Account already exists
            if (!tpUtility->accountExists()){
                qDebug() << "VICaR account not found. Creating ..";
                bool result = tpUtility->createAccount();
                if (!result) exit(1);
            }
            else{
                qDebug() << "VICaR account found.";
            }
        }
        else if (instruction == "REMOVE"){

            bool result = tpUtility->deleteAccount();
            if (!result) exit(2);
        }
    }

    delete (tpUtility);
    tpUtility = 0;
}
