/* libsharing.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Sharing", lower_case_cprefix = "sharing_")]
namespace Sharing {
	[Compact]
	[CCode (cheader_filename = "sharing-account.h")]
	public class Account {
		public unowned string get_param (string key);
		public bool set_option_values (string key, GLib.SList<Sharing.ServiceOptionValue> values);
		public bool set_param (string key, string value);
	}
	[Compact]
	[CCode (cheader_filename = "sharing-entry.h")]
	public class Entry {
		public unowned Sharing.Account get_account ();
		public unowned GLib.SList<Sharing.EntryMedia> get_media ();
		public unowned string get_option (string id);
		public uint64 get_size ();
	}
	[Compact]
	[CCode (cheader_filename = "sharing-entry-media.h")]
	public class EntryMedia {
		public unowned string get_desc ();
		public unowned string get_filename ();
		public unowned string get_filename_without_extension ();
		public unowned string get_localpath ();
		public unowned string get_mime ();
		public unowned string get_name ();
		public bool get_sent ();
		public uint64 get_size ();
		public unowned GLib.SList<Sharing.Tag> get_tags ();
		public unowned string get_title ();
		public void set_metadata_editable (bool editable);
		public void set_sent (bool sent);
	}
	[Compact]
	[CCode (ref_function = "sharing_http_ref", unref_function = "sharing_http_unref", cheader_filename = "sharing-http.h")]
	public class HTTP {
		[CCode (type = "SharingHTTP*", has_construct_function = false)]
		public HTTP ();
		public bool add_req_header (string name, string value);
		public bool add_req_header_line (string line);
		public bool add_req_multipart_data (string name, string data, int data_len, string type);
		public bool add_req_multipart_file (string name, string filepath, string type);
		public bool add_req_multipart_file_with_filename (string name, string filepath, string type, string filename);
		public void cancel ();
		public void clear_multiparts ();
		public unowned ConIc.Connection get_connection ();
		public unowned string get_res_body (size_t len);
		public size_t get_res_buffer_size_limit ();
		public int get_res_code ();
		public unowned string get_res_content (size_t len);
		public void remove_req_headers ();
		public Sharing.HTTPRunResponse run (string url);
		public void set_connection (ConIc.Connection connection);
		public void set_progress_callback (Sharing.HTTPProgressCallback callback);
		public void set_res_buffer_size_limit (size_t limit);
		public void set_timeouts (long connecting_timeout, long connection_timeout);
		public void set_user_agent_name (string name);
	}
	[Compact]
	[CCode (cheader_filename = "sharing-service.h")]
	public class Service {
		public unowned string get_name ();
		public static void option_values_free (GLib.SList<Sharing.ServiceOptionValue> values);
	}
	[Compact]
	[CCode (cheader_filename = "sharing-service.h")]
	public class ServiceOptionValue {
		[CCode (type = "SharingServiceOptionValue*", has_construct_function = false)]
		public ServiceOptionValue (string id, string name, string description);
	}
	[Compact]
	[CCode (cheader_filename = "sharing-tag.h")]
	public class Tag {
		public unowned string get_word ();
	}
	[Compact]
	[CCode (cheader_filename = "sharing-transfer.h")]
	public class Transfer {
		public bool @continue ();
		public unowned Sharing.Account get_account ();
		public unowned Sharing.Entry get_entry ();
		public void set_progress (double value);
	}
	[CCode (cprefix = "SHARING_HTTP_RUNRES_", has_type_id = false, cheader_filename = "sharing-http.h")]
	public enum HTTPRunResponse {
		SUCCESS,
		UNKNOWN_FAILURE,
		INVALID_PARAMETERS,
		CONNECTION_PROBLEM,
		CANCELLED,
		ALREADY_RUNNING
	}
	[CCode (cprefix = "SHARING_ACCOUNT_SETUP_", has_type_id = false, cheader_filename = "sharing-plugin-interface.h")]
	public enum PluginInterfaceAccountSetupResult {
		SUCCESS,
		ERROR_UNKNOWN,
		ERROR_CONNECTION
	}
	[CCode (cprefix = "SHARING_ACCOUNT_VALIDATE_", has_type_id = false, cheader_filename = "sharing-plugin-interface.h")]
	public enum PluginInterfaceAccountValidateResult {
		SUCCESS,
		ACCOUNT_NOT_FOUND,
		FAILED,
		ERROR_UNKNOWN,
		ERROR_CONNECTION,
		NOT_STARTED,
		CANCELLED
	}
	[CCode (cprefix = "SHARING_EDIT_ACCOUNT_", has_type_id = false, cheader_filename = "sharing-plugin-interface.h")]
	public enum PluginInterfaceEditAccountResult {
		SUCCESS,
		ERROR_UNKNOWN,
		ERROR_CONNECTION,
		NOT_STARTED,
		DELETE,
		CANCELLED
	}
	[CCode (cprefix = "SHARING_SEND_", has_type_id = false, cheader_filename = "sharing-plugin-interface.h")]
	public enum PluginInterfaceSendResult {
		SUCCESS,
		ERROR_UNKNOWN,
		ERROR_AUTH,
		ERROR_CONNECTION,
		CANCELLED,
		ERROR_FILE_FORMAT,
		ERROR_UPLOAD_LIMIT,
		ERROR_ACCOUNT_NOT_FOUND,
		ERROR_TIMEOUT
	}
	[CCode (cprefix = "SHARING_UPDATE_OPTIONS_", has_type_id = false, cheader_filename = "sharing-plugin-interface.h")]
	public enum PluginInterfaceUpdateOptionsResult {
		SUCCESS,
		ERROR_UNKNOWN,
		CANCELLED,
		NO_UPDATE_FUNCTIONALITY,
		ERROR_PARAMETERS
	}
	[CCode (cprefix = "SHARING_TAG_", has_type_id = false, cheader_filename = "sharing-plugin-interface.h")]
	public enum TagType {
		SHARE,
		GEO_COUNTRY,
		GEO_CITY,
		GEO_SUBURB,
		FAVOURITE,
		GPS_LATITUDE,
		GPS_LONGITUDE,
		GPS_ALTITUDE,
		CREATOR,
		UNKNOWN
	}
	[CCode (cheader_filename = "sharing-http.h")]
	public delegate bool HTTPProgressCallback (Sharing.HTTP http, uint64 bytes_sent);
	[CCode (cheader_filename = "sharing-plugin-interface.h", has_target = false)]
	public delegate Sharing.PluginInterfaceAccountSetupResult PluginInterfaceAccountSetup (Gtk.Window parent, Sharing.Service service, out unowned Sharing.Account worked_on, Osso.Context osso);
	[CCode (cheader_filename = "sharing-plugin-interface.h", has_target = false)]
	public delegate Sharing.PluginInterfaceAccountValidateResult PluginInterfaceAccountValidate (Sharing.Account account, ConIc.Connection con, bool cont, bool dead_mans_switch);
	[CCode (cheader_filename = "sharing-plugin-interface.h", has_target = false)]
	public delegate Sharing.PluginInterfaceEditAccountResult PluginInterfaceEditAccount (Gtk.Window parent, Sharing.Account account, ConIc.Connection con, bool dead_mans_switch);
	[CCode (cheader_filename = "sharing-plugin-interface.h", has_target = false)]
	public delegate uint PluginInterfaceInit (bool dead_mans_switch);
	[CCode (cheader_filename = "sharing-plugin-interface.h", has_target = false)]
	public delegate Sharing.PluginInterfaceSendResult PluginInterfaceSend (Sharing.Transfer transfer, ConIc.Connection con, bool dead_mans_switch);
	[CCode (cheader_filename = "sharing-plugin-interface.h", has_target = false)]
	public delegate uint PluginInterfaceUninit (bool dead_mans_switch);
	[CCode (cheader_filename = "sharing-plugin-interface.h", has_target = false)]
	public delegate bool PluginInterfaceUpdateOptions (Sharing.Account account, ConIc.Connection con, bool cont, bool dead_mans_switch, Sharing.UpdateOptionsCallback cb_func, void* cb_data);
	[CCode (cheader_filename = "sharing-plugin-interface.h", has_target = false)]
	public delegate void UpdateOptionsCallback (Sharing.PluginInterfaceUpdateOptionsResult result, void* cb_data);
	[CCode (cheader_filename = "sharing-plugin-interface.h")]
	public const string PLUGIN_INTERFACE_ACCOUNT_SETUP;
	[CCode (cheader_filename = "sharing-plugin-interface.h")]
	public const string PLUGIN_INTERFACE_ACCOUNT_VALIDATE;
	[CCode (cheader_filename = "sharing-plugin-interface.h")]
	public const string PLUGIN_INTERFACE_EDIT_ACCOUNT;
	[CCode (cheader_filename = "sharing-plugin-interface.h")]
	public const string PLUGIN_INTERFACE_INIT;
	[CCode (cheader_filename = "sharing-plugin-interface.h")]
	public const string PLUGIN_INTERFACE_SEND;
	[CCode (cheader_filename = "sharing-plugin-interface.h")]
	public const string PLUGIN_INTERFACE_UNINIT;
	[CCode (cheader_filename = "sharing-plugin-interface.h")]
	public const string PLUGIN_INTERFACE_UPDATE_OPTIONS;
}
