#!/usr/bin/python
# -*- coding: utf-8 -*-
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 and higer.
##
## Guseynov Alexey (kibergus bark-bark gmail.com) 2010

import pexpect
import time
from subprocess import *
import sys
import gsmdecode
import re
import fcntl

def check_number(number):
	if number == "":
		return False
	for s in number :
		if not (s in ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "+", "*", "#"]) :
			return False
	return True

if len(sys.argv) == 1 or len(sys.argv) > 5 or (sys.argv[1] == "interactive" and len(sys.argv) > 4):
    print "Usage:\nussdquery.py <ussd number> [<language> [<number of allowed errors> [<allow error on last query>]]]\nussdquery.py interactive [<language> [<delimiter>]]\nAllowed languages: German, English, Italian, French, Spanish, Dutch, Swedish, Danish, Portuguese, Finnish, Norwegian, Greek, Turkish, Reserved1, Reserved2, Unspecified\nFor USSD menu navigation divide USSD number via spacebars for every nex menu selection.\nDefaults: allowed errors = 0 (use -1 for infinite), allow error on last query = true, delimiter = '\\n> '"
    sys.exit()

retry = 0
allow_last_error = True
delimiter = "\n> "

if sys.argv[1] == "interactive":
	number = "interactive"
else:
	number = sys.argv[1].split(" ")
	for n in number: 
		if not check_number(n):
			print >> sys.stderr, "Sintax error in USSD number."
			sys.exit(-7)

language = 15
if len(sys.argv) > 2:
	if sys.argv[2] == "German":
		language = 0
	elif sys.argv[2] == "English":
		language = 1
	elif sys.argv[2] == "Italian":
		language = 2
	elif sys.argv[2] == "French":
		language = 3
	elif sys.argv[2] == "Spanish":
		language = 4
	elif sys.argv[2] == "Dutch":
		language = 5
	elif sys.argv[2] == "Swedish":
		language = 6
	elif sys.argv[2] == "Danish":
		language = 7
	elif sys.argv[2] == "Portuguese":
		language = 8
	elif sys.argv[2] == "Finnish":
		language = 9
	elif sys.argv[2] == "Norwegian":
		language = 10
	elif sys.argv[2] == "Greek":
		language = 11
	elif sys.argv[2] == "Turkish":
		language = 12
	elif sys.argv[2] == "Reserved1":
		language = 13
	elif sys.argv[2] == "Reserved2":
		language = 14
	elif sys.argv[2] == "Unspecified":
		language = 15
	else:
		print >> sys.stderr, "Language unknown, falling back to unspecified."

if len(sys.argv) > 3:
	if number == "interactive":
		delimiter = sys.argv[3]
	else:
		try:
			retry = int(argv[3])
			if retry < -1:
				print >> sys.stderr, "Number of allowed rrors must be >= -1. -1 assumed."
				retry = -1
		except:
			print >> sys.stderr, "Third argument must be an integer."
			sys.exit(-5)

if number != "interactive" and len(sys.argv) > 4:
	if sys.argv[4] == "true":
		allow_last_error = True
	elif sys.argv[4] == "false":
		sllow_last_error = False
	else :			 
		print >> sys.stderr, "Unrecognized forth argument."
		sys.exit(-5)

if retry == -1:
	retry_forever = True
else:
	retry_forever = False

# We have only one modem, simultaneous acces wouldn't bring anything good
lockf = open("/tmp/ussdquery.lock", 'a')
fcntl.flock(lockf,fcntl.LOCK_EX)

# Operations should timeout in 30 seconds.
child = None
response = ""
init_retry = 5
while response != "OK" and init_retry > 0 :
	if child == None :
		# OK response should be recieved shortly
		child = pexpect.spawn('pnatd', [], 2)
	try :
		child.send('at\r');
		# Read our "at" command
		child.readline();
		# Read OK response
		response = child.readline().strip()
	except pexpect.TIMEOUT:
		child.kill(9)
		child = None
		response = ""
	if response != "OK" :
		time.sleep(0.5)
		init_retry -= 1

if response != "OK" :
	print >> sys.stderr, "Couldn't init modem."
	if child != None:
		child.kill(9)
        fcntl.flock(lockf,fcntl.LOCK_UN)
        lockf.close()
	sys.exit (-1)

child.timeout = 30
# Now we are ready to send commands

stage = 0
if number == "interactive":
	sys.stdout.write(delimiter)
while number == "interactive" or stage < len(number):
	if number == "interactive":
		cnumber = sys.stdin.readline().strip()
		if cnumber == "quit":
			child.kill(9)
			fcntl.flock(lockf,fcntl.LOCK_UN)
			lockf.close()
			sys.exit (-2)
		if not check_number (cnumber):
			sys.stdout.write ("Sintax error in USSD number"+delimiter)
			continue
	else:
		cnumber = number[stage]

	if retry == -1 and not retry_forever:
		print >> sys.stderr, "Retry limit is over. Giving up."
		break

	try :
		child.send('at+cusd=1,"'+cnumber+'",'+str(language)+'\r')
		# Read our query echoed back
		child.readline()

		#Read and parse reply
		replystring = child.readline().decode('string_escape')
		# This will read out unneeded info from modem
		child.readline()
		child.readline()
	except pexpect.TIMEOUT:
		print >> sys.stderr, "Timeout. Modem didn't reply."
		child.kill(9)
        	fcntl.flock(lockf,fcntl.LOCK_UN)
        	lockf.close()
		sys.exit (-2)

	if replystring.strip() == "ERROR" :
		retry -= 1
		print >> sys.stderr, "Modem returned ERROR. Query not executed."
		continue

	try:
		reresult = re.match("(?s)^\\+CUSD: \\d+,\"(.*)\",(\\d+)$", replystring.strip())
		reply = reresult.group(1)
		encoding = reresult.group(2)
	except:
		retry -= 1
		print >> sys.stderr, "Couldn't parse modem answer."
		continue

	# Decoding ansver
	reply = gsmdecode.decode(reply, int(encoding))

	if number == "interactive":
		# prints line feed
		sys.stdout.write(reply+delimiter)
	else:
		if stage == len(number)-1:
			print reply
	stage += 1
	if not allow_last_error and namber != "interactive" and stage == len(number) - 1:
		retry = 0

child.sendeof()
fcntl.flock(lockf,fcntl.LOCK_UN)
lockf.close()
