#!/usr/bin/python
# -*- coding: utf-8 -*-
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 and higer.
##
## Guseynov Alexey (kibergus bark-bark gmail.com) 2010

import pexpect
import time
from subprocess import *
import sys
import gsmdecode
import re
import fcntl

if len(sys.argv) != 2:
    print "Usage: ussdquery.py <ussd number>"
    sys.exit()

# We have only one modem, simultaneous acces wouldn't bring anything good
lockf = open("/tmp/ussdquery.lock", 'a')
fcntl.flock(lockf,fcntl.LOCK_EX)

# Operations should timeout in 30 seconds.
# I'm not shure, that readline uses timeouts
child = None
response = ""
retry = 5
while response != "OK" and retry > 0 :
	if child == None :
		# OK response should be recieved shortly
		child = pexpect.spawn('pnatd', [], 2)
	try :
		child.send('at\r');
		# Read our "at" command
		child.readline();
		# Read OK response
		response = child.readline().strip()
	except pexpect.TIMEOUT:
		child.kill(9)
		child = None
		response = ""
	if response != "OK" :
		time.sleep(0.5)
		retry -= 1

if response != "OK" :
	print >> sys.stderr, "Couldn't init modem."
	if child != None:
		child.kill(9)
        fcntl.flock(lockf,fcntl.LOCK_UN)
        lockf.close()
	sys.exit (-1)

child.timeout = 30

try :
	child.send('at+cusd=1,"'+(sys.argv[1])+'",15\r')
	# Read our query echoed back
	child.readline()

	#Read and parse reply
	replystring = child.readline()
except pexpect.TIMEOUT:
	print >> sys.stderr, "Timeout. Modem didn't reply."
	child.kill(9)
        fcntl.flock(lockf,fcntl.LOCK_UN)
        lockf.close()
	sys.exit (-2)

child.sendeof()
fcntl.flock(lockf,fcntl.LOCK_UN)
lockf.close()


if replystring.strip() == "ERROR" :
	print >> sys.stderr, "Modem returned ERROR. Query not executed."
	sys.exit (-3)

try:
	reresult = re.match("^\\+CUSD: \\d+,\"(.*)\",(\\d+)$", replystring.strip())
	reply = reresult.group(1)
	encoding = reresult.group(2)
except:
	print >> sys.stderr, "Couldn't parse modem answer."
	sys.exit (-4)

# Decoding ansver
reply = gsmdecode.decode(reply, int(encoding))

print reply

