/**************************************************************************

    URPO

    Unix Remote Printing Operation
    Copyright (c) Arto Hyvättinen 2010

    This file is part of URPO.

    URPO is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    URPO is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


**************************************************************************/

#ifndef URPOMAINWINDOW_H
#define URPOMAINWINDOW_H

#include <QtGui/QMainWindow>

class PrintWidget;
class PrintJob;
class PrinterListJob;
class UrpoConnectionSettings;
class DebugConsole;
class QTextBrowser;

/*! GUI class for URPO main window

  @author Arto Hyvättinen
  @version 0.1
  @date 2010-06-17

  */
class UrpoMainWindow : public QMainWindow
{
    Q_OBJECT

public:
    UrpoMainWindow(QWidget *parent = 0);
    ~UrpoMainWindow();

public slots:
    /*! Populate printer QCombo and enable printing  */
    void printersReceived(bool success, QString error);
    /*! Start printers getting */
    void getPrinters();
    /*! Show about dialog */
    void about();
    /*! Show settings dialog */
    void settings();
    /*! Show help window */
    void helpWindow();
    /*! Show debug window */
    void debugWindow();
    /*! Print file  */
    void print(QString file, QString options);
    /*! Print finished, enable buttons */
    void printFinished(bool success, QString errorStr);

private:
    void initMenu();
    void initHelp();

private:
    PrintWidget*    printWidget_;
    PrinterListJob* printerListJob_;
    PrintJob*       printJob_;
    UrpoConnectionSettings* settings_;
    DebugConsole*   monitor_;
    QTextBrowser*   helpBrowser_;


};

#endif // URPOMAINWINDOW_H
