/**************************************************************************

    URPO

    Unix Remote Printing Operation
    Copyright (c) Arto Hyvättinen 2010

    This file is part of URPO.

    URPO is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    URPO is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


**************************************************************************/

#ifndef URPOCONNECTION_H
#define URPOCONNECTION_H


#include <QString>
class QObject;

/*! Information about ssh connection (abstract)

@author Arto Hyvättinen
@date 2010-06-11
@version 1
@abstract


  */
class UrpoConnection
{
protected:
    UrpoConnection();
public:
    virtual ~UrpoConnection();

    /*! Host name or ip address

      @return Server host name of ip address */
    virtual QString getHost() const = 0;

    /*! Userid in server

      @return userid in server */
    virtual QString getUserid() const = 0;

    /*! Identity file

      ssh identity file (private key)

      @return ssh identity file path */
    virtual QString getIdentity() const = 0;

    /*! Default time out in connection

      Connection fais if connecting or commanding lasts
      more than timeout.

      @return default timeout in msecs */


    /*! Set Debug monitor

      Debug monitor is QObject receiving debugMsg(QString&) signals.
      @param monitor QObject receiving debug messages */
    void setDebugMonitor(QObject* monitor);

    /*! Get pointer to Debug monitor

      Debug monitor is QObject receiving debugMsg(QString&) signals.
      @return QObject receiving debug messages */
    QObject* getDebugMonitor() const;

    /*! user@@host -string


      @return user@@host -string
      */
    QString getHostString();

    /*!  Key option needed for ssh


        @return -i key_file or empty if no keyfile
      */
    QString getKeyOption();

private:
    /*! Receiver for debugMsg(QString&) signals */
    QObject* debugMonitor_;
};

#endif // URPOCONNECTION_H
