/**************************************************************************

    URPO

    Unix Remote Printing Operation
    Copyright (c) Arto Hyvättinen 2010

    This file is part of URPO.

    URPO is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    URPO is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


**************************************************************************/

#ifndef PRINTJOB_H
#define PRINTJOB_H

#include <urpojob.h>


/*! File printing job'

  @author Arto Hyvättinen
  @date 2010-06-17
  @version 0.1

 Job for printing files.
 First, connect finished()-signal (called when ready)
 Then, printFile()

 @note start() is not for use!

  */
class PrintJob : public UrpoJob
{
    Q_OBJECT
public:
    explicit PrintJob(UrpoConnection* connection);
    ~PrintJob();

signals:

public slots:
    /*! When file has copied (internal use only) */
    void copyReady(bool success);
    /*! When files has printed (internal use only) */
    void printReady(bool success);
    /*! When file has deleted (internal use only) */
    void deleteReady(bool success);

    /*! Print sigle file

      @arg path Path to file
      @arg printOptions cups print options for lp command

      When finished, emit finished() signal

      */
    void printFile(const QString& path, const QString& printOptions);

    /*! Do not use, thows execption!

      This function exits only because of bad class planning.
      @note Do NOT use!

    @throw std::logic_error Thow error becouse this function is not for use!*/
    void startJob();
    /*! Cancel printing job */
    void cancelJob();

private:
    inline void freeProcess();

private:
    UrpoProcess* currentProcess_;
    QString pathToPrint_;
    QString printOptions_;


};

#endif // PRINTJOB_H
