/**************************************************************************

    URPO

    Unix Remote Printing Operation
    Copyright (c) Arto Hyvättinen 2010

    This file is part of URPO.

    URPO is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    URPO is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


**************************************************************************/

#ifndef PRINTERLISTJOB_H
#define PRINTERLISTJOB_H


#include "urpojob.h"
#include <QStringList>

/*!  Get list of available printers

    @author Arto Hyvättinen
    @version 0
    @date 2010-06-11

    connect finished() and call start().
    getPrinters() tell printers of remote host.

  */

class PrinterListJob : public UrpoJob
{
    Q_OBJECT
public:
    explicit PrinterListJob(UrpoConnection* connection);
    /*! List of printers in system */
    QStringList getPrinters() const { return printers_; }

signals:

public slots:
    /*! Read output and do printer list */
    void doList(bool success);

protected:
    void startJob();
    void cancelJob();

private:
    QStringList printers_;
    UrpoProcess* process_;
};

#endif // PRINTERLISTJOB_H
