 /*
  * UAE - The Un*x Amiga Emulator
  *
  * Support for platform-independent key-mapping
  *
  * Copyright 2004 Richard Drummond
  */


/*
 * Platform-independent key-codes
 */
enum {
    UAEKEY_ESCAPE = 1,

    UAEKEY_F1,
    UAEKEY_F2,
    UAEKEY_F3,
    UAEKEY_F4,
    UAEKEY_F5,
    UAEKEY_F6,
    UAEKEY_F7,
    UAEKEY_F8,
    UAEKEY_F9,
    UAEKEY_F10,
    UAEKEY_F11,
    UAEKEY_F12,

    UAEKEY_PRINTSCR,
    UAEKEY_SCROLL_LOCK,
    UAEKEY_PAUSE,

    UAEKEY_1,
    UAEKEY_2,
    UAEKEY_3,
    UAEKEY_4,
    UAEKEY_5,
    UAEKEY_6,
    UAEKEY_7,
    UAEKEY_8,
    UAEKEY_9,
    UAEKEY_0,

    UAEKEY_MINUS,
    UAEKEY_EQUALS,

    UAEKEY_BACKSPACE,
    UAEKEY_ENTER,
    UAEKEY_SPACE,

    UAEKEY_TAB,

    UAEKEY_A,
    UAEKEY_B,
    UAEKEY_C,
    UAEKEY_D,
    UAEKEY_E,
    UAEKEY_F,
    UAEKEY_G,
    UAEKEY_H,
    UAEKEY_I,
    UAEKEY_J,
    UAEKEY_K,
    UAEKEY_L,
    UAEKEY_M,
    UAEKEY_N,
    UAEKEY_O,
    UAEKEY_P,
    UAEKEY_Q,
    UAEKEY_R,
    UAEKEY_S,
    UAEKEY_T,
    UAEKEY_U,
    UAEKEY_V,
    UAEKEY_W,
    UAEKEY_X,
    UAEKEY_Y,
    UAEKEY_Z,

    UAEKEY_LEFTBRACKET,
    UAEKEY_RIGHTBRACKET,
    UAEKEY_SEMICOLON,
    UAEKEY_SINGLEQUOTE,
    UAEKEY_GRAVE,
    UAEKEY_BACKSLASH,
    UAEKEY_COMMA,
    UAEKEY_PERIOD,
    UAEKEY_SLASH,
    UAEKEY_LTGT,

    UAEKEY_NUMLOCK,
    UAEKEY_NUMPAD1,
    UAEKEY_NUMPAD2,
    UAEKEY_NUMPAD3,
    UAEKEY_NUMPAD4,
    UAEKEY_NUMPAD5,
    UAEKEY_NUMPAD6,
    UAEKEY_NUMPAD7,
    UAEKEY_NUMPAD8,
    UAEKEY_NUMPAD9,
    UAEKEY_NUMPAD0,
    UAEKEY_NUMPAD_PERIOD,
    UAEKEY_NUMPAD_PLUS,
    UAEKEY_NUMPAD_MINUS,
    UAEKEY_NUMPAD_MULTIPLY,
    UAEKEY_NUMPAD_DIVIDE,
    UAEKEY_NUMPAD_ENTER,
    UAEKEY_NUMPAD_EQUALS,	/* Mac keyboards have this */
    UAEKEY_NUMPAD_LPAREN,	/* Amiga keyboards have this */
    UAEKEY_NUMPAD_RPAREN,	/* Amiga keyboards have this */
    UAEKEY_INSERT,
    UAEKEY_DELETE,
    UAEKEY_HOME,
    UAEKEY_END,
    UAEKEY_PAGEUP,
    UAEKEY_PAGEDOWN,

    UAEKEY_CURSOR_UP,
    UAEKEY_CURSOR_DOWN,
    UAEKEY_CURSOR_LEFT,
    UAEKEY_CURSOR_RIGHT,

    UAEKEY_LEFT_CTRL,
    UAEKEY_LEFT_SHIFT,
    UAEKEY_LEFT_ALT,
    UAEKEY_LEFT_SUPER,
    UAEKEY_RIGHT_SUPER,
    UAEKEY_RIGHT_ALT,
    UAEKEY_MENU,
    UAEKEY_RIGHT_SHIFT,
    UAEKEY_RIGHT_CTRL,
    UAEKEY_CAPSLOCK,

    UAEKEY_HELP,

    UAEKEY_POWER,
    UAEKEY_SLEEP,
    UAEKEY_WAKE,

    UAEKEY_TOTAL_KEYS
};

/*
 * Platform-independent modifier codes
 */
enum {
    UAEMODKEY_LSHIFT,
    UAEMODKEY_LCTRL,
    UAEMODKEY_LALT,
    UAEMODKEY_LSUPER,
    UAEMODKEY_RSUPER,
    UAEMODKEY_RALT,
    UAEMODKEY_RCTRL,
    UAEMODKEY_RSHIFT,
    UAEMODKEY_CAPSLOCK,
    UAEMODKEY_TOTAL_KEYS
};

struct uaekey_hostmap
{
    short hostkey;
    short uaekey;
};


struct uae_input_device_kbr_default *uaekey_make_default_kbr (const struct uaekey_hostmap *hostkeys);
