/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "timelinectrl.h"

/*! \brief Constructs a TimelineCtrl.
 */
TimelineCtrl::TimelineCtrl(QGraphicsScene *scene)
{
    qDebug() << "+ " << __PRETTY_FUNCTION__;

    _scene = scene;

    _timelineView = new TimelineView();

    connect(_timelineView, SIGNAL(lockRotation(bool)), SIGNAL(lockRotation(bool)));
    connect(_timelineView, SIGNAL(postUpdate(void)), this, SLOT(_postNewUpdate(void)));
    connect(_timelineView, SIGNAL(deleteTweet(quint64)), this, SLOT(_handleDeleteTweet(quint64)));
    connect(_timelineView, SIGNAL(getTimeline(Timeline::TimelineType)),
            Backend::getInstance(), SLOT(getTimeline(Timeline::TimelineType)));
    connect(_timelineView, SIGNAL(done()),this, SLOT(deleteLater()));
    connect(_timelineView, SIGNAL(homeRefresh()), SLOT(_refreshHome()));
    connect(_timelineView, SIGNAL(mentionsRefresh()), SLOT(_refreshMentions()));
    connect(_timelineView, SIGNAL(moreHomeTweets()), SLOT(_moreHomeTweets()));
    connect(_timelineView, SIGNAL(moreMentions()), SLOT(_moreMentions()));

    showView();

    Backend::getInstance()->getTimeline(Timeline::Friends);
    connect(Backend::getInstance(), SIGNAL(gotFriendsTimeline()), SLOT(_populateHome()));
    connect(Backend::getInstance(), SIGNAL(gotMentions()), SLOT(_populateMentions()));
    connect(Backend::getInstance(), SIGNAL(updatePosted()), SLOT(_updatePosted()));
    connect(Backend::getInstance(), SIGNAL(deletedTweet(quint64)), SLOT(_deletedTweet(quint64)));
}

/*!
 * \brief TimelineCtrl destructor.
 */
TimelineCtrl::~TimelineCtrl()
{
    Backend::getInstance()->abort();
    Backend::getInstance()->resetTimelinePage(Timeline::Friends);
    Backend::getInstance()->resetTimelinePage(Timeline::Mentions);

    delete ImageDownload::instance();

    if(_timelineView)
        delete _timelineView;

    emit done();
}

/*!
 *\brief This function adds the timelineview to the scene.
 */
void TimelineCtrl::showView()
{
    _timelineView->createUi();
    _scene->addItem(_timelineView);
}

/*!
 *\brief This function gets what user typed and updates as a new status and calls
 *       timelineview to update user stats and timeline.
 */
void TimelineCtrl::_postNewUpdate()
{
    Backend::getInstance()->update(_timelineView->getUpdateMessage(), "", "", _timelineView->_statusId);
}

/*!
 *\brief This function provides an error messagebox to any error that might occur.
 *\param message message that will appear on the messagebox.
 */
void TimelineCtrl::_genericError(QString message)
{
    // TODO
}

/*!
 *\brief This function shows an error while trying to update the status and asks
 * if the user wants to retry or quit.
 *\param message message that will appear on the messagebox.
 */
void TimelineCtrl::_updateWarning(QString message)
{
    // TODO
}

/*!
 *\brief This function shows an error while trying to refresh the time and asks
 * if the user wants to retry or quit.
 *\param message message that will appear on the messagebox.
 */
void TimelineCtrl::_refreshWarning(QString message)
{
    // TODO
}

/*!
 *\brief Gets status id from selected status and adds it as favorite.
 */
void TimelineCtrl::_handleFavorite(QString tweetId,bool isFavorite)
{
    // TODO
}

/*!
 *\brief Gets status id from selected status and deletes it.
 */
void TimelineCtrl::_handleDeleteTweet(quint64 id)
{
    Backend::getInstance()->removeStatus(id);
}

/*!
 *\brief Gets username from selected status and removes/adds it from/to following list.
 */
void TimelineCtrl::_handleFriendship(QString username, bool unfollow)
{
    // TODO
}

/*!
 * \brief Updates the user avatar.
 * \param image User's new image.
 */
void TimelineCtrl::_updateProfileImage(QString image)
{
    // TODO
}

/*!
 * \brief Shows the dialog when user clicks on the location checkbox and calls the location method especified by the user
 */
void TimelineCtrl::_dialogLocation()
{
    // TODO
}

/*!
 * \brief Saves latitude and longitude in a string and shows a banner when acquiring and stopping GPS
 */
void TimelineCtrl::_handleGPSLocation()
{
    // TODO
}

void TimelineCtrl::_populateHome(void)
{
    EntryList entries = Backend::getInstance()->getHomeTweets();

    foreach( const Entry &entry, entries ) {
        Tweet *tweet = new Tweet(entry,NULL);
        _timelineView->_homeTimeline->addToList(tweet);
    }

    _timelineView->addMoreButton(Timeline::Friends);
    _timelineView->endLoader();
}

void TimelineCtrl::_populateMentions(void)
{
    EntryList entries = Backend::getInstance()->getMentionsTweets();

    foreach( const Entry &entry, entries ) {
        Tweet *tweet = new Tweet(entry,NULL);
        _timelineView->_mentionsTimeline->addToList(tweet);
    }

    _timelineView->addMoreButton(Timeline::Mentions);
    _timelineView->endLoader();
}

void TimelineCtrl::_updatePosted(void)
{
    Entry entry = Backend::getInstance()->getUpdateTweet();

    Tweet *tweet = new Tweet(entry,NULL);
    _timelineView->_homeTimeline->addToList(tweet,0);

    _timelineView->_statusId = 0;
    _timelineView->clearText();
    _timelineView->updateTopBar();
    _timelineView->endLoader();
}

void TimelineCtrl::_refreshHome(void)
{
    _timelineView->_homeTimeline->clearList();
    Backend::getInstance()->resetTimelinePage(Timeline::Friends);
    Backend::getInstance()->getTimeline(Timeline::Friends);
}

void TimelineCtrl::_moreHomeTweets(void)
{
    Backend::getInstance()->getTimeline(Timeline::Friends);
}

void TimelineCtrl::_refreshMentions(void)
{
    _timelineView->_mentionsTimeline->clearList();
    Backend::getInstance()->resetTimelinePage(Timeline::Mentions);
    Backend::getInstance()->getTimeline(Timeline::Mentions);
}

void TimelineCtrl::_moreMentions(void)
{
    Backend::getInstance()->getTimeline(Timeline::Mentions);
}

void TimelineCtrl::_deletedTweet(quint64 id)
{
    _timelineView->updateTopBar();
    _timelineView->tweetDeleted(id);
}
