/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "applicationmanager.h"

/*!
 * \brief ApplicationManager constructor.
 */
ApplicationManager::ApplicationManager(QGraphicsScene *scene)
    : _autologin(true)
{
    _scene = scene;
}

/*!
 * \brief Creates a new loginScreen controller.
 */
void ApplicationManager::loginScreen()
{
    _loginCtrl = new LoginCtrl(_autologin, _scene);
    connect(_loginCtrl,SIGNAL(done()),this, SIGNAL(loginFinished()));
}

/*!
 * \brief Creates a new timelineScreen controller.
 */
void ApplicationManager::timelineScreen()
{
    _timelineCtrl = new TimelineCtrl(_scene);
    connect(_timelineCtrl,SIGNAL(done()),this, SIGNAL(timelineFinished()));
    _autologin = false;
}
