/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef DIALOG_H
#define DIALOG_H

#include "twitterapplicationitem.h"
#include "twitterbutton.h"

/*!
 * \class DialogView
 *
 * \brief Dialog View class
 *
 * Handles dialog view windows.
 */
class DialogView : public TwitterApplicationItem
{
    Q_OBJECT

public:
    enum Type { Warning, Error, Location };

    DialogView(DialogView::Type type, QString message="", QGraphicsWidget *parent = 0);

private:
    void createConnects(void);

signals:
    void yesPressed(void);
    void noPressed(void);
    void getIP(void);
    void getGPS(void);
    void cancelPressed(void);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

public slots:
    void buttonPressed();

private:
    Type _type;
    QString _message;
    TwitterButton *_button1;
    TwitterButton *_button2;
    TwitterButton *_button3;
    TwitterButton *_exposeButton;
    QGraphicsRectItem *m_background;
};

#endif
