/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef LOGINSETTINGS_H
#define LOGINSETTINGS_H

#include "twitterapplicationitem.h"
#include "applicationItems/twitterbutton.h"
#include "applicationItems/twittercheckbox.h"

class LoginSettings : public TwitterApplicationItem
{
    Q_OBJECT

public:
    LoginSettings(QGraphicsWidget *parent);
    void setSelected(int selected);

public slots:
    void startAnimation(void);

private slots:
    void _exitAnimation(void);
    void _autoLogin(void);

private:
    void _loadSettings(void);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

private:
    QGraphicsPixmapItem *_bg;
    QGraphicsTextItem *_title;
    QGraphicsLineItem *_sep1;
    QGraphicsLineItem *_sep2;
    TwitterButton *_backButton;
    TwitterCheckBox *_autologinCheckBox;
    bool autologin;
    QFont font;
    int _sel;
};

#endif // LOGINSETTINGS_H
