/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "dialog.h"

/*!
 * \brief DialogView constructor.
 */
DialogView::DialogView(DialogView::Type type, QString message, QGraphicsWidget *parent)
        : TwitterApplicationItem(parent),
        _type(type)
{
    this->setGeometry(0,0,800,480);

    _exposeButton = new TwitterButton(TwitterButton::Expose,"",this);
    _exposeButton->setPos(0,0);
    _exposeButton->setZValue(2.0);

    /* Dark Background */
    m_background = new QGraphicsRectItem(QRectF(0,0,800,480),this);
    m_background->setOpacity(0.5);
    m_background->setZValue(1.0);
    m_background->setBrush(Qt::black);

    /* White Rectangle */
    QGraphicsPixmapItem *box = new QGraphicsPixmapItem(this);
    box->setPixmap(QPixmap::fromImage(QImage(":images/resources/failed.png")));
    box->setPos((this->boundingRect().width() - box->boundingRect().width())/2,
                (this->boundingRect().height() - box->boundingRect().height())/2);
    box->setZValue(2.0);

    /* Rectangle Message */
    _message = "<center><p style=\" font-size:18px; padding-bottom:0px; margin-bottom:0px; font-family:'Nokia Sans';\"> ";
    _message += message;
    _message += "</center></p>";

    QGraphicsTextItem *text = new QGraphicsTextItem(this);
    text->setHtml(_message);
    text->setDefaultTextColor(QColor(0,0,0));
    text->setTextWidth(386);
    text->setPos(box->pos().x() + 32, box->pos().y() + 88);
    text->setZValue(3.0);

    switch(_type) {
        case Error:
            _button1 = new TwitterButton(TwitterButton::Generic, "Ok", this);
            _button1 ->setPos((box->boundingRect().width() - _button1->boundingRect().width())/2
                                + box->pos().x(), box->boundingRect().height() - 20);
            _button1->setZValue(3.0);
            break;

        case Warning:
            _button1 = new TwitterButton(TwitterButton::Generic, "Yes", this);
            _button1->setPos((box->boundingRect().width()/2 - _button1->boundingRect().width())/2
                               + box->pos().x(), box->boundingRect().height() - 20);
            _button1->setZValue(3.0);

            _button2 = new TwitterButton(TwitterButton::Generic, "No", this);
            _button2->setPos((box->boundingRect().width()/2 - _button2->boundingRect().width())/2
                              + box->pos().x() + box->boundingRect().width()/2, box->boundingRect().height() - 20);
            _button2->setZValue(3.0);
            break;

        case Location:
            _button1 = new TwitterButton(TwitterButton::Generic, "IP", this);
            _button1->setPos((box->boundingRect().width()/3 - _button1->boundingRect().width())/2
                              + box->pos().x() + 32, box->boundingRect().height() - 20);
            _button1->setZValue(3.0);

            _button2 = new TwitterButton(TwitterButton::Generic, "GPS", this);
            _button2->setPos(_button1->pos().x() + box->boundingRect().width()/3 - 32, box->boundingRect().height() - 20);
            _button2->setZValue(3.0);

            _button3 = new TwitterButton(TwitterButton::Generic, "Cancel", this);
            _button3->setPos(_button2->pos().x() + box->boundingRect().width()/3 -32, box->boundingRect().height() - 20);
            _button3->setZValue(3.0);
            break;
    }

    this->createConnects();
}

void DialogView::createConnects(void)
{
    switch(_type) {
        case Warning:
            connect(_button2, SIGNAL(released()), this, SLOT(buttonPressed()));
            connect(_button2, SIGNAL(released()), this, SIGNAL(noPressed()));

        case Error:
            connect(_button1, SIGNAL(released()), this, SLOT(buttonPressed()));
            connect(_button1, SIGNAL(released()), this, SIGNAL(yesPressed()));
            break;

        case Location:
            connect(_button1, SIGNAL(released()), this, SIGNAL(getIP()));
            connect(_button1, SIGNAL(released()), this, SLOT(buttonPressed()));

            connect(_button2, SIGNAL(released()), this, SIGNAL(getGPS()));
            connect(_button2, SIGNAL(released()), this, SLOT(buttonPressed()));

            connect(_button3, SIGNAL(released()), this, SIGNAL(cancelPressed()));
            connect(_button3, SIGNAL(released()), this, SLOT(buttonPressed()));
            break;
    }
}

/*!
 * \brief Implement the button pressed event
 * */
void DialogView::buttonPressed()
{
    QVariantAnimation *anim = new QPropertyAnimation(this, "opacity");
    anim->setEndValue(0);
    anim->setDuration(500);
    anim->start(QAbstractAnimation::DeleteWhenStopped);
    connect(anim, SIGNAL(finished()), SLOT(deleteLater()));
}

void DialogView::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    Q_UNUSED(event);
}
