/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include <QtGui/QApplication>
#include <QtGui/QGraphicsView>
#include <QtCore/QStateMachine>

#include "applicationmanager.h"

/*!
 * \brief The main method
 *  Creates the state machine, creates the transitions and starts the state machine.
 */
int main (int argc, char **argv)
{
    QApplication app(argc, argv);
    QApplication::setOrganizationName("Zagaia");
    QApplication::setApplicationName("TweeGo");

    QGraphicsScene scene(0, 0, 800, 480);
    QGraphicsView view(&scene);

    QStateMachine machine;
    QState *loginState = new QState();
    QState *timelineState = new QState();

    ApplicationManager *appManager = new ApplicationManager(&scene);

    loginState->addTransition(appManager,SIGNAL(loginFinished()),timelineState);
    timelineState->addTransition(appManager,SIGNAL(timelineFinished()),loginState);

    QObject::connect(loginState,SIGNAL(entered()),appManager,SLOT(loginScreen()));
    QObject::connect(timelineState,SIGNAL(entered()),appManager,SLOT(timelineScreen()));

    QObject::connect(&machine, SIGNAL(finished()), QApplication::instance(), SLOT(quit()));

    machine.addState(loginState);
    machine.addState(timelineState);
    machine.setInitialState(loginState);

//    QNetworkProxy proxy;
//    proxy.setType(QNetworkProxy::HttpProxy);
//    proxy.setHostName("172.19.244.1");
//    proxy.setPort(3128);
//    proxy.setUser("indt.mikhail.gadelha");
//    proxy.setPassword("indt.mikhail.gadelha");
//    QNetworkProxy::setApplicationProxy(proxy);

    machine.start();

    view.setFixedSize(800, 480);
    view.setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    view.setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    view.setFrameStyle(0);
    view.showFullScreen();

    QPalette p = view.viewport()->palette();
    p.setColor(QPalette::Base, Qt::transparent);
    view.viewport()->setPalette(p);
//    view.setAttribute(Qt::WA_TranslucentBackground, true);

    return app.exec();
}
