/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "user.h"

User::User(QString username, QImage avatar, int pos, QGraphicsWidget *parent)
    : TwitterApplicationItem(parent),
    _defaultAvatar(QImage(":images/resources/avatar.png")),
    _username(QString(username)),
    _bgColor(QColor(246,253,255)),
    _pos(pos)
{
    this->setMinimumSize(299,74);

    // Draw default avatar if the user is new
    if(avatar.isNull())
        _avatar = _defaultAvatar;
    else
        _avatar = avatar;

    // Create text object to draw on the screen
    _name = new QGraphicsTextItem(this);

    // Draw username on the screen
    drawName(true);
}

void User::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{
    Q_UNUSED(option);
    Q_UNUSED(widget);

    painter->setBrush(_bgColor);
    painter->setPen(Qt::NoPen);
    painter->setRenderHint(QPainter::Antialiasing);
    painter->drawRoundedRect(0, 0, rect().width(), rect().height(), 2, 2);

    painter->setBrush(QColor(246,253,255));
    painter->drawRect(13,13,48,48);

    painter->drawImage(QRect(13,13,48,48),_avatar);
}

void User::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    Q_UNUSED(event);
}

void User::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
{
    if(!contains(event->pos()))
        return;
    select();
}

void User::unselect(void)
{
    _bgColor = QColor(246,253,255);
    update();
    drawName(true);
}

void User::drawName(bool isSelected)
{
    QString colorHex = "#ffffff";;
    if(isSelected)
        colorHex = "#0f95da";

    QString messageHtml = "<p style=\" font-size:18px; padding-bottom:0px; margin-bottom:0px; font-family:'Nokia Sans';\"> ";
    messageHtml += "<span style=\" color:" + colorHex + ";\">" + _username + "</span></p>";
    _name->setHtml(messageHtml);
    _name->setPos(74,(rect().height() - _name->boundingRect().height())/2);
}

void User::select(void)
{
    _bgColor = QColor(0,173,239);
    update();
    emit selected(_pos);
    drawName(false);
}
