/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "twittercheckbox.h"

/*!
 *\brief TwitterCheckBox constructor.
 *\param _checkImg image for a selected checkBox.
 *\param _checkEmptyImg image for a unselected checkBox.
 *\param _initPos draw checkBox position.
 *\param _checked value of checkBox. If it is selected its value is
 *       TRUE, otherwise FALSE.
 */
TwitterCheckBox::TwitterCheckBox(CheckBoxType type, bool checked, QGraphicsWidget *parent)
        : TwitterApplicationItem(parent),
        _checked(checked)
{
    setAcceptHoverEvents(true);
    setCacheMode(DeviceCoordinateCache);

    _checkboxType = type;
    setCheckBoxType(_checkboxType);
}

/*!
 *\brief Reimplements the boundingRect function.
 *\return Defines the item as a rectangle.
 */
QRectF TwitterCheckBox::boundingRect() const
{
    return _checkImg.rect();
}

/*!
 *\brief Reimplement the contents of an item in local coordinates.
 *\param painter for item painting implementation.
 *\param option parameter provides style options for the item.
 *\param widget argument is optional, it points to the widget that is being painted on.
 */
void TwitterCheckBox::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *)
{
//    bool down = option->state & QStyle::State_Sunken;
//    painter->drawPixmap(0, 0, _checkEmptyImg);
//    if (down)
//        _checked = !_checked;

//    if (_checked)
//        painter->drawPixmap(0, 0, _checkImg);
    if(_checked)
        painter->drawPixmap(0,0,_checkImg);
    else
        painter->drawPixmap(0,0,_checkEmptyImg);
}

/*!
 * \brief This function implements the checkBox status.
 * \return TRUE if checkBox is checked otherwise FALSE
 */
bool TwitterCheckBox::isChecked()
{
    return _checked;
}

/*!
 * \brief This function sets the checkBox status.
 * \param checkBox value.
 */
void TwitterCheckBox::setChecked(bool value)
{
    _checked = value;
    update();
}

/*!
 * \brief Reimplemented to receive mouse press events.
 * \param mouse event
 */
void TwitterCheckBox::mousePressEvent(QGraphicsSceneMouseEvent *)
{
    _checked = !_checked;
    emit pressed();
    update();
}

/*!
 * \brief This function sets the checkbox type, changing the image.
 * \param type The type of checkbox.
 */
void TwitterCheckBox::setCheckBoxType(int type)
{
    switch(type) {
        case RememberMe:
            _checkEmptyImg = QPixmap(":images/resources/checkbox/remember-me.png");
            _checkImg = QPixmap(":images/resources/checkbox/remember-me_pressed.png");
            break;
        case Location:
            _checkEmptyImg = QPixmap(":images/resources/checkbox/map_pressed.png");
            _checkImg = QPixmap(":images/resources/checkbox/map.png");
            break;
        case Settings:
            _checkEmptyImg = QPixmap(":images/resources/checkbox/yes.png");
            _checkImg = QPixmap(":images/resources/checkbox/no.png");
            break;
    }
    setGeometry(0,0,_checkImg.width(),_checkImg.height());
}
