#ifndef TIMELINESETTINGS_H
#define TIMELINESETTINGS_H

#include "twitterapplicationitem.h"
#include "applicationItems/twitterbutton.h"

class TimelineSettings : public TwitterApplicationItem
{
    Q_OBJECT

public:
    TimelineSettings(QGraphicsWidget *parent);

private:
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

signals:
    void logout(void);

public slots:
    void startAnimation(void);

private slots:
    void _exitAnimation(void);
    void _logout(void);

private:
    TwitterButton *_logoutButton;
    TwitterButton *_backButton;
    QGraphicsLineItem *_sep1;
    QGraphicsTextItem *_infos;
};

#endif // TIMELINESETTINGS_H
