/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "timelinectrl.h"

/*! \brief Constructs a TimelineCtrl.
 */
TimelineCtrl::TimelineCtrl(QGraphicsScene *scene)
{
    qDebug() << "+ " << __PRETTY_FUNCTION__;

    _scene = scene;

    _timelineView = new TimelineView();

//    isFollowing = true;
//    updateTimeline = false;
//    isGPS = false;
//    pageToDownload = 2;
//    mentionsPageToDownload = 2;
//    addHome = true;
//    addMentions = true;

    connect(_timelineView, SIGNAL(postUpdate(void)), this, SLOT(_postNewUpdate(void)));
//    connect(_timelineView, SIGNAL(favorite(QString, bool)), this, SLOT(_handleFavorite(QString, bool)));
    connect(_timelineView, SIGNAL(deleteTweet(quint64)), this, SLOT(_handleDeleteTweet(quint64)));
//    connect(_timelineView, SIGNAL(logout()), this, SLOT(_logout()));
//    connect(_timelineView, SIGNAL(unfollow(QString, bool)), this, SLOT(_handleFriendship(QString, bool)));
    connect(_timelineView, SIGNAL(done()),this, SLOT(deleteLater()));
    connect(_timelineView, SIGNAL(refresh()), SLOT(_refreshTimeline()));
    connect(_timelineView, SIGNAL(moreTweets()), SLOT(_moreTweets()));
//    connect(_timelineView, SIGNAL(changeAvatar(QString)), this, SLOT(_updateProfileImage(QString)));

//    connect(_timelineView, SIGNAL(showLocationDialog()), this, SLOT(_dialogLocation()));
//    connect(_timelineView, SIGNAL(gotGPS()), this, SLOT(_handleGPSLocation()));

//    connect(Backend::getInstance(), SIGNAL(updateError(QString)), this, SLOT(_updateWarning(QString)));
//    connect(Backend::getInstance(), SIGNAL(connectionError(QString)), this, SLOT(_refreshWarning(QString)));

    showView();

    Backend::getInstance()->getTimeline(Timeline::Friends);
    connect(Backend::getInstance(), SIGNAL(entryList(EntryList)), SLOT(_populateTimeline(EntryList)));
    connect(Backend::getInstance(), SIGNAL(updatePosted(EntryList)), SLOT(_updatePosted(EntryList)));
    connect(Backend::getInstance(), SIGNAL(deletedTweet(quint64)),SLOT(_deletedTweet(quint64)));
}

/*!
 * \brief TimelineCtrl destructor.
 */
TimelineCtrl::~TimelineCtrl()
{
    Backend::getInstance()->abort();
    if(_timelineView)
        delete _timelineView;

    emit done();
}

/*!
 *\brief This function adds the timelineview to the scene.
 */
void TimelineCtrl::showView()
{
    _timelineView->createUi();
    _scene->addItem(_timelineView);
}

/*!
 *\brief This function gets what user typed and updates as a new status and calls
 *       timelineview to update user stats and timeline.
 */
void TimelineCtrl::_postNewUpdate()
{
    Backend::getInstance()->update(_timelineView->getUpdateMessage(), "", "", _timelineView->m_statusId);
//    bool updated = false;

//    if(_timelineView->getHome())
//        _timelineView->m_homeTimeline->moreButtonEnable(false);
//    else
//        _timelineView->m_mentionsTimeline->moreButtonEnable(false);

//    if (_timelineView->getUpdateMessage() != "") {
//        if(!_timelineView->_locationCheckBox->isChecked()) {
//            if(!_timelineView->isReply)
//                updated = Backend::getInstance()->update(_timelineView->getUpdateMessage(), NULL, NULL);
//            else {
//                updated = Backend::getInstance()->update(_timelineView->getUpdateMessage(), NULL, NULL, _timelineView->m_statusId);
//                qDebug() << "status id = " << _timelineView->m_statusId;
//                _timelineView->isReply = false;
//                _timelineView->m_statusId.clear();
//            }
//        }
//        else {
//            if(!isGPS) {
//                if(!_timelineView->isReply) {
//                    updated = Backend::getInstance()->update(_timelineView->getUpdateMessage(),
//                                                     QString::number(_timelineView->_ipLocation->getLat()),
//                                                     QString::number(_timelineView->_ipLocation->getLon()));
//                }
//                else {
//                    updated = Backend::getInstance()->update(_timelineView->getUpdateMessage(),
//                                                     QString::number(_timelineView->_ipLocation->getLat()),
//                                                     QString::number(_timelineView->_ipLocation->getLon()), _timelineView->m_statusId);
//                    _timelineView->isReply = false;
//                    _timelineView->m_statusId.clear();
//                }
//            }
//            else {
//                if(!_timelineView->isReply)
//                    updated = Backend::getInstance()->update(_timelineView->getUpdateMessage(), gpsLatitude, gpsLongitude);
//                else {
//                    updated = Backend::getInstance()->update(_timelineView->getUpdateMessage(), gpsLatitude, gpsLongitude, _timelineView->m_statusId);
//                    _timelineView->isReply = false;
//                    _timelineView->m_statusId.clear();
//                }
//            }
//        }
//    } else
//        _genericError("The message cannot be empty");

//    if(updated)
//        _timelineView->setUpdateMessage("") ;

//    if(_timelineView->getHome())
//        _timelineView->m_homeTimeline->moreButtonEnable(true);
//    else
//        _timelineView->m_mentionsTimeline->moreButtonEnable(true);
}

/*!
 *\brief This function handles any connection errors that might occur.
 *\param message message that will appear on the messagebox.
 */
void TimelineCtrl::_connectionError(QString message)
{
//    dialog = new DialogView(DialogView::Error, message);
//    _scene->addItem(dialog);
//    _timelineView->connectionError();
}

/*!
 *\brief This function provides an error messagebox to any error that might occur.
 *\param message message that will appear on the messagebox.
 */
void TimelineCtrl::_genericError(QString message)
{
//    dialog = new DialogView(DialogView::Error, message);
//    _scene->addItem(dialog);
//    _timelineView->endLoader();
}

/*!
 *\brief This function shows an error while trying to update the status and asks
 * if the user wants to retry or quit.
 *\param message message that will appear on the messagebox.
 */
void TimelineCtrl::_updateWarning(QString message)
{
//    dialog = new DialogView(DialogView::Warning,message);
//    connect(dialog, SIGNAL(yesPressed()), this, SLOT(_postNewUpdate()));
//    connect(dialog, SIGNAL(noPressed()), _timelineView, SLOT(endLoader()));
//    _scene->addItem(dialog);
}

/*!
 *\brief This function shows an error while trying to refresh the time and asks
 * if the user wants to retry or quit.
 *\param message message that will appear on the messagebox.
 */
void TimelineCtrl::_refreshWarning(QString message)
{
//    dialog = new DialogView(DialogView::Warning,message);
//    connect(dialog, SIGNAL(yesPressed()), this, SLOT(_updateTimeline()));
//    connect(dialog, SIGNAL(noPressed()), _timelineView, SLOT(_backToLogin()));
//    _scene->addItem(dialog);
}

/*!
 *\brief Gets status id from selected status and adds it as favorite.
 */
void TimelineCtrl::_handleFavorite(QString tweetId,bool isFavorite)
{
//    qDebug() << "+ " << __PRETTY_FUNCTION__;

//    bool success;
//    success = Backend::getInstance()->addFavorite(tweetId.toLongLong(), isFavorite);

//    if(success) {
//        _timelineView->_tweetInfo->updateTweetInfo("Favorite", !isFavorite);
//        _timelineView->endLoader();
//    }
//    else
//        this->_genericError("Could not favorite tweet.");
}

/*!
 *\brief Gets status id from selected status and deletes it.
 */
void TimelineCtrl::_handleDeleteTweet(quint64 id)
{
    Backend::getInstance()->removeStatus(id);
//    success = Backend::getInstance()->removeStatus(tweetId.toLongLong());
//    if(success) {
//        _timelineView->m_homeTimeline->removeFromList(posInList);
//        this->_updateTimeline();
//    }
//    else
//        this->_genericError("Could not remove status.");

//    if(_timelineView->getHome())
//        _timelineView->m_homeTimeline->moreButtonEnable(true);
//    else
//        _timelineView->m_mentionsTimeline->moreButtonEnable(true);
}

/*!
 *\brief Gets username from selected status and removes/adds it from/to following list.
 */
void TimelineCtrl::_handleFriendship(QString username, bool unfollow)
{
//    qDebug() << "+ " << __PRETTY_FUNCTION__;

//    bool success;

//    if(unfollow) {
//        success = Backend::getInstance()->removeFriendship(username);
//        _updateTimeline();
//    }
//    else {
//        success = Backend::getInstance()->addFriendship(username);
//        _updateTimeline();
//    }

//    if(success) {
//        _timelineView->_tweetInfo->updateTweetInfo("Follow",!unfollow);
//        _timelineView->m_homeTimeline->populateFollowing(username, !unfollow);
//    }
//    else
//        this->_genericError("Error");
}

/*!
 *\brief Shows a confirmation dialog when user tries to logout.
 */
void TimelineCtrl::_logout()
{
//    dialog = new DialogView(DialogView::Warning, QString("Are you sure you want to quit?"));
//    connect(dialog, SIGNAL(yesPressed()), _timelineView, SLOT(_backToLogin()));
//    _scene->addItem(dialog);
}

/*!
 * \brief Clears all information on the current list
 * and creates a new list with updated information.
 */
void TimelineCtrl::_updateTimeline()
{
//    qDebug() << "+ " << __PRETTY_FUNCTION__;

//    Backend::getInstance()->verifyCredentials();
//    _timelineView->updateTopBar();
//    _timelineView->endLoader();
}

/*!
 * \brief Updates the user avatar.
 * \param image User's new image.
 */
void TimelineCtrl::_updateProfileImage(QString image)
{
//    qDebug() << "+ " << __PRETTY_FUNCTION__;

//    bool newImage = Backend::getInstance()->updateProfileImage(image);

//    if(newImage) {
//        _timelineView->updateTopBar();
//        this->_genericError("The new avatar has been updated!\nThe new avatar will be loaded when you perform another action.");
//    }
//    else
//        this->_genericError("The new avatar could not be updated.");
}

/*!
 * \brief Shows the dialog when user clicks on the location checkbox and calls the location method especified by the user
 */
void TimelineCtrl::_dialogLocation()
{
//    if(!_timelineView->_locationCheckBox->isChecked()) {
//        dialog = new DialogView(DialogView::Location,"Choose one method to obtain your coordinates");
//        connect(dialog, SIGNAL(getIP()), _timelineView, SLOT(getIPCoordinates()));
//        connect(dialog, SIGNAL(getGPS()), _timelineView, SLOT(getGPSCoordinates()));
//        connect(dialog, SIGNAL(cancelPressed()), _timelineView, SLOT(setLocationCheckboxFalse()));
//        _scene->addItem(dialog);
//    }
//    else {
//        isGPS = false;
//        #ifdef LIBLOCATION
//            _timelineView->_gpsLocation->stop();
//        #endif // LIBLOCATION
//    }
}

/*!
 * \brief Saves latitude and longitude in a string and shows a banner when acquiring and stopping GPS
 */
void TimelineCtrl::_handleGPSLocation()
{
//    qDebug() << "+ " << __PRETTY_FUNCTION__;
//    #ifdef LIBLOCATION
//    if(_timelineView->_locationCheckBox->isChecked())
//        QMaemo5InformationBox::information(NULL, tr("GPS information updated!"), QMaemo5InformationBox::DefaultTimeout);
//    else
//        QMaemo5InformationBox::information(NULL, tr("GPS stopped"), QMaemo5InformationBox::DefaultTimeout);

//    gpsLatitude = QString::number(_timelineView->_gpsLocation->getLat());
//    gpsLongitude = QString::number(_timelineView->_gpsLocation->getLon());
//    #endif // LIBLOCATION
//    isGPS = true;
}

void TimelineCtrl::_populateTimeline(EntryList entries)
{
    foreach( const Entry &entry, entries )
    {
        Tweet *tweet = new Tweet(entry,NULL);
        _timelineView->_homeTimeline->addToList(tweet);
    }
    _timelineView->addMoreButton();
    _timelineView->endLoader();
}

void TimelineCtrl::_updatePosted(EntryList entries)
{
    foreach( const Entry &entry, entries )
    {
        Tweet *tweet = new Tweet(entry,NULL);
        _timelineView->_homeTimeline->addToList(tweet,0);
    }
    _timelineView->m_statusId = 0;
    _timelineView->setUpdateMessage("");
    _timelineView->endLoader();
}

void TimelineCtrl::_refreshTimeline(void)
{
    _timelineView->_homeTimeline->clearList();
    _timelineView->startLoader();
    Backend::getInstance()->setFriendsPage(1);
    Backend::getInstance()->getTimeline(Timeline::Friends);
}

void TimelineCtrl::_moreTweets(void)
{
    _timelineView->startLoader();
    Backend::getInstance()->getTimeline(Timeline::Friends);
}

void TimelineCtrl::_deletedTweet(quint64 id)
{
    _timelineView->tweetDeleted(id);
}
