#include "maemo5gps.h"

#ifdef Q_WS_MAEMO_5

/*! \brief Maemo5GPS constructor.
 */
Maemo5GPS::Maemo5GPS(QObject *parent) : QObject(parent) {
    latitude = 0;
    longitude = 0;
    accuracy = 0;
    usegps = -1;

    control = location_gpsd_control_get_default();
    device = (LocationGPSDevice*) g_object_new(LOCATION_TYPE_GPS_DEVICE, NULL);
    g_signal_connect(device, "changed", G_CALLBACK(Maemo5GPS_changed), this);
}

/*!
 * \brief Maemo5GPS destructor.
 */
Maemo5GPS::~Maemo5GPS()
{
}

/*!
 * \brief Sets the preferred method to ACWP
 */
void Maemo5GPS::get_acwp() {
    g_object_set(G_OBJECT(control), "preferred-method", LOCATION_METHOD_ACWP, NULL);
    usegps = 0;
    restart();
}

/*!
 * \brief Sets the preferred method to AGNSS
 */
void Maemo5GPS::get_agnss() {
    g_object_set(G_OBJECT(control), "preferred-method", LOCATION_METHOD_AGNSS, NULL);
    usegps = 1;
    restart();
}

/*!
 * \brief Stops LocationGPSDControl GObject
 */
void Maemo5GPS::stop() {
    location_gpsd_control_stop(control);
}

/*!
 * \brief Restarts LocationGPSDControl GObject
 */
void Maemo5GPS::restart() {
    location_gpsd_control_stop(control);
    location_gpsd_control_start(control);
}

/*!
 * \brief Gets latitude and longitude from LocationGPSDevice GObject when a fix exists
 * \param device LocationGPSDevice GObject
 * \param gps Maemo5GPS object
 */
void Maemo5GPS_changed(LocationGPSDevice *device, Maemo5GPS *gps) {
    if (gps->device->fix) {
        if (gps->device->fix->fields) {
            g_print("lat = %f, long = %f, eph = %f\n", gps->device->fix->latitude, gps->device->fix->longitude, gps->device->fix->eph/100.);
            gps->latitude = gps->device->fix->latitude;
            gps->longitude = gps->device->fix->longitude;
            gps->accuracy = gps->device->fix->eph/100.;

            if ( gps->usegps == 0) {
                emit gps->getOK_acwp();
                if ( gps->accuracy < 10*1000 ) gps->stop();
            } else if ( gps->usegps == 1 ) {
                       emit gps->getOK_agnss();
                       // if ( device->satellites_in_use > 0 ) gps->stop();
                       if ( gps->device->fix->mode == LOCATION_GPS_DEVICE_MODE_3D ) gps->stop();
                    } else
                          emit gps->getOK();
        }
    }
}

#endif
