/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef SPLASHVIEW_H
#define SPLASHVIEW_H

#include <QtCore/QTimer>

#include <QtCore/QObject>
#include <QtGui/QBrush>
#include <QtGui/QGraphicsScene>
#include <QtGui/QPainter>
#include <QtGui/QStyleOptionGraphicsItem>

#include "applicationItems/twitterapplicationitem.h"
#include "applicationItems/loader.h"

/*!
 * \class SplashView
 *
 * \brief SplashView interface class that loads the splash screen
 */
class SplashView : public QGraphicsWidget
{
    Q_OBJECT

public:
    SplashView(void);
    ~SplashView(void);
    void createUi(void);

private:
    TwitterApplicationItem *_logo;

public slots:
    void onStatic(void);

signals:
    void done(void);

};
#endif // SPLASHVIEW_H
