/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "dialog.h"

/*!
 * \brief DialogView constructor.
 */
DialogView::DialogView(DialogView::Type type, QGraphicsWidget *parent)
        : TwitterApplicationItem(parent)
{
    _title = tr("title");
    _message = tr("message");
    _type = type;
    resize(800, 640);
    switch(_type) {
        case Error:
            _okButton = new TwitterButton(TwitterButton::Generic, "Ok", this);
            _okButton->setPos(355, 280);
            connect(_okButton, SIGNAL(released()), this, SLOT(buttonPressed()));
            break;
        case Warning:
            _yesButton = new TwitterButton(TwitterButton::Generic, "Yes", this);
            _yesButton->setPos(260, 280);
            _noButton = new TwitterButton(TwitterButton::Generic, "No", this);
            _noButton->setPos(450, 280);
            connect(_yesButton, SIGNAL(released()), this, SLOT(buttonPressed()));
            connect(_noButton, SIGNAL(released()), this, SLOT(buttonPressed()));

            connect(_yesButton, SIGNAL(released()), this, SIGNAL(yesPressed()));
            connect(_noButton, SIGNAL(released()), this, SIGNAL(noPressed()));
            break;
    }
}

/*!
 * \brief DialogView destructor.
 */
DialogView::~DialogView()
{
}

/*!
 * \brief Shows Dialog with configured animation.
 */
void DialogView::exec()
{
    (void) _eventLoop.exec(QEventLoop::DialogExec);
}

/*!
 * \brief Exit DialogView
 */
int DialogView::exit(void)
{
    _eventLoop.exit(0);
    this->deleteLater();
    return 0;
}
/*!
 * \brief Set title
 * \param String to title of dialog
 */
void DialogView::setTitle(const QString &title)
{
    _title = title;
}
/*!
 * \brief Set message
 * \param String to message of dialog
 */
void DialogView::setMessage(const QString &message)
{
    _message = message;
}

/*!
 * \brief Overridden.
 * \param painter Painter object.
 * \param option Styles to drawing.
 * \param widget argument is optional, it points to the widget that is being painted on.
 */
void DialogView::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
    QRectF textRect = QRectF(220, 140, 370, 130);
    int flags = Qt::AlignTop | Qt::AlignCenter | Qt::TextWordWrap;

    QFont font;
    font.setFamily("Nokia Sans");
    font.setPixelSize(18);
    painter->drawPixmap(180, 100, QPixmap(":images/resources/failed.png"));
    painter->setPen(Qt::black);
    painter->setFont(font);
    painter->drawText(textRect, flags, _message);
}

/*!
 * \brief Implement the button pressed event
 * */
void DialogView::buttonPressed()
{
    QVariantAnimation *anim = new QPropertyAnimation(this, "opacity");
    anim->setEndValue(0);
    anim->setDuration(700);
    anim->start(QAbstractAnimation::DeleteWhenStopped);
    connect(anim, SIGNAL(finished()), SLOT(exit()));
}



