/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TWITTERTIMELINE_H
#define TWITTERTIMELINE_H

#include <QtCore/QObject>
#include <QtCore/QRectF>

#include <QtGui/QStyleOptionGraphicsItem>
#include <QtGui/QGraphicsSceneMouseEvent>
#include <QtGui/QPixmap>
#include <QtGui/QPainter>
#include <QtGui/QDesktopServices>

#include <QPropertyAnimation>

#include <QtNetwork>

#include "twitterapplicationitem.h"
#include "flickable.h"
#include "backend.h"

#include "twitterbutton.h"

/*!
 * \class TwitterTimeline
 *
 * \brief TwitterTimeline class handles all operations related to timelines
 */
class TwitterTimeline : public QWidget, public Flickable
{
    Q_OBJECT

public:
    TwitterTimeline(QWidget *parent = 0);
    ~TwitterTimeline(void);
    QList<QImage> orderUserImages(QList<QImage>);

    QString getRetweet(int postion);
    QString getUsername(int position);
    QString getStatusId(int position);
    QList<QString> parseSource(QList<QString> source);
    QList<QString> parseCreatedAt(QList<QString> createdAt);

    QString getTweetName(void);
    QString getTweetText(void);
    QString getTweetUrl(void);
    QString getTweetId(void);
    QString getTweetSource(void);
    QImage  getUserImage(void);
    QString getTweetCreatedAt(void);
    QString getTweetFavorite(void);
    QString getCoordinates(void);
    int getHighlight(void);
    void setTweetFavorite(QString isFavorite);

signals:
    void pressed(void);
    void released(void);
    void finished(void);
    void getMoreTweets(void);
    void createTweetInfo(void);

protected:
// reimplement from Flickable
virtual QPoint scrollOffset() const {
    return QPoint(0, m_offset);
}

// reimplement from Flickable
virtual void setScrollOffset(const QPoint &offset) {
    int yy = offset.y();
    if (yy != m_offset) {
        m_offset = qBound(0, yy, m_height * tweetsInfo.count() - height());

        update();
    }
}

protected:
    void paintEvent(QPaintEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

private slots:
    void handleNetworkRequest(QNetworkReply *reply);
    void download(QString Url);

public slots:
    void moreTweets(void);

private:
    int m_offset;
    int m_height;
    int m_highlight;
    int pages;
    int numberOfUrls;
    int numberOfDownloadedUrls;
    bool paintImages;
    QStringList tweetsInfo;
    QList<QString> tweetName;
    QList<QString> tweetText;
    QList<QString> tweetUrl;
    QList<QString> tweetId;
    QList<QString> tweetCreatedAt;
    QList<QString> tweetCreatedAt2;
    QList<QString> tweetSource;
    QList<QString> tweetSource2;
    QList<QString> tweetFavorite;
    QList<QString> tweetCoordinates;
    QList<QString> downloadedUrl;
    QNetworkAccessManager m_manager;
    QList<QImage> userImages;
    QStringList timelineList;
    QImage m_image;
};	

#endif // TWITTERTIMELINE_H
