import Qt 4.7

Item {
    property string text
    property int max: 0
    property int loadid: 0
    property int tested: 0
    // anchors.horizontalCenter: parent.horizontalCenter
    function storeColumn(type, phrase, position, timeout, notify) {
        var db = openDatabaseSync("QitterDB", "1.0", "Qitter column index", 1000000);

        db.transaction(
            function(tx) {
                // Create the database if it doesn't already exist
                // tx.executeSql('CREATE TABLE IF NOT EXISTS Columns (type VARCHAR(32) NOT NULL, phrase VARCHAR(128), position MEDIUMINT)');

                // Insert column data
                tx.executeSql('INSERT INTO Columns (type, phrase, position, timeout, notify) VALUES(?, ?, ?, ?, ?)', [ type, phrase, position, timeout, notify ]);
                max = position
                console.log("Max is " + max)
            }
        )
        console.log("Added to Db '" + type + "' with phrase '" + phrase + "' at position " + position)
    }

    function removeRow(posit) {
        var db = openDatabaseSync("QitterDB", "1.0", "Qitter column index", 1000000);
        db.transaction(
            function(tx) {
                tx.executeSql('DELETE FROM Columns WHERE position = ?', posit)
            }
        )
        console.log("Deleted column at position " + posit)
        console.log("Max is " + max)
    }

    function getColumns(which) {
        var db = openDatabaseSync("QitterDB", "1.0", "Qitter column index", 1000000);
        checkDb();
        db.transaction(
            function(tx) {
                var rs = tx.executeSql('SELECT * FROM Columns ORDER BY position ASC')
                max = 0;
                screen.js().cols = rs.rows;
                console.log("length: " + screen.js().cols.length);
                for(var i = 0; i < rs.rows.length; i++) {
                    if (rs.rows.item(i).position > max) {
                        max = rs.rows.item(i).position;
                    }
                }
            }
        )
        loadid = 0;
        tested = 0;
        screen.js().populateLoadedcols(screen.js().cols.length);
        loadNext();
    }

    function switchPosit(first, second) {
        var db = openDatabaseSync("QitterDB", "1.0", "Qitter column index", 1000000);
        checkDb();
        db.transaction(
            function(tx) {
                var query = 'SELECT rowid,* FROM Columns WHERE position = ' + first + ' LIMIT 1';
                        console.log(query);
                var rs1 = tx.executeSql(query)

                console.log(rs1.rows.item(0).rowid);

                query = 'SELECT rowid,* FROM Columns WHERE position = ' + second + ' LIMIT 1';
                        console.log(query);
                var rs2 = tx.executeSql(query)
                if (rs1.rows.length == 1 && rs2.rows.length == 1) {
                    query = 'UPDATE Columns SET position = ' + second + ' WHERE rowid = ' + rs1.rows.item(0).rowid
                    console.log(query);
                    tx.executeSql(query)
                    query = 'UPDATE Columns SET position = ' + first + ' WHERE rowid = ' + rs2.rows.item(0).rowid
                    console.log(query);
                    tx.executeSql(query)
                    console.log("positions switched in db")
                } else {
                    console.log("wrong amount of rows when storing position");
                }
            }
        )

    }

    function storeAuth(username, password) {
        if (username.length < 1) return;
        var db = openDatabaseSync("QitterDB", "1.0", "Qitter column index", 1000000);

        db.transaction(
            function(tx) {
                // Create the database if it doesn't already exist


                // Insert column data
                tx.executeSql('DELETE FROM Userdata WHERE userid = 0');
                tx.executeSql('INSERT INTO Userdata (userid, username, password) VALUES(?, ?, ?)', [ 0, username, password ]);
                console.log("Stored user " + username);
            }
        )
    }

    function getAuth() {
        var db = openDatabaseSync("QitterDB", "1.0", "Qitter column index", 1000000);
        var ret = false;
        db.transaction(
            function(tx) {

                var rs = tx.executeSql('SELECT * FROM Userdata WHERE userid = 0')
                if (rs.rows.length > 0) {
                    console.log("Found user " + rs.rows.item(0).username);
                    ret = [rs.rows.item(0).username, rs.rows.item(0).password];
                }
            }
        )
        return ret;
    }

    function getSetting(setting) {
        var db = openDatabaseSync("QitterDB", "1.0", "Qitter column index", 1000000);
        var ret = false;
        db.transaction(
            function(tx) {
                var rs = tx.executeSql('SELECT * FROM Settings WHERE setting = "' + setting + '" LIMIT 1');
                if (rs.rows.length > 0) {
                    ret = rs.rows.item(0).value
                } else ret = null;
            }
        )
        return ret;
    }

    function storeSetting(setting,value, username) {
        var db = openDatabaseSync("QitterDB", "1.0", "Qitter column index", 1000000);
        var ret = false;
        db.transaction(
            function(tx) {
                tx.executeSql('DELETE FROM Settings WHERE setting = "' + setting + '"');
                tx.executeSql('INSERT INTO Settings (setting, value, username) VALUES(?, ?, ?)', [ setting, value, username ]);
            }
        )
    }

    function checkDb() {
        console.log("checking databases")
        var db = openDatabaseSync("QitterDB", "1.0", "Qitter column index", 1000000);

        db.transaction(
            function(tx) {
                // create if not exist
                tx.executeSql('CREATE TABLE IF NOT EXISTS Columns (type VARCHAR(32) NOT NULL, phrase VARCHAR(128), position MEDIUMINT, timeout MEDIUMINT NOT NULL DEFAULT 0, notify TINYINT NOT NULL DEFAULT 0)');
                tx.executeSql('CREATE TABLE IF NOT EXISTS Userdata (userid MEDIUMINT NOT NULL, username VARCHAR(32), password VARCHAR(32))');
                tx.executeSql('CREATE TABLE IF NOT EXISTS Settings (username VARCHAR(32), setting VARCHAR(32), value VARCHAR(64))');
                /* var rs = tx.executeSql('PRAGMA table_info(Columns)');
                console.log("columns: " + rs.rows.length);
                if (rs.rows.length < 4) {
                    tx.executeSql('ALTER TABLE Columns ADD timeout MEDIUMINT NOT NULL DEFAULT 0;');
                    console.log("db altered, added timeout");
                }
                if (rs.rows.length < 5) {
                    tx.executeSql('ALTER TABLE Columns ADD notify TINYINT NOT NULL DEFAULT 0;');
                    console.log("db altered, added notify");
                } */
            }
        )
    }

    function loadNext() {
        console.log("loadid: " + loadid);
        console.log("length: " + screen.js().cols.length);
        // softload.stop(); //stop timer
        if (loadid < screen.js().cols.length) {
            if (mainrowModel.count == 0 || screen.js().loadedcols[loadid - 1] || tested > 10) {
                loading.loadtext = "Loading columns (" + (loadid + 1) + "/" + screen.js().cols.length + ")"
                console.log("previous loaded: " + screen.js().loadedcols[loadid - 1])
                console.log("current  loaded: " + screen.js().loadedcols[loadid])
                tested = 0;
                console.log("adding row of type " + screen.js().cols.item(loadid).type);
                loadid++
                mainrowModel.append({ "search": screen.js().cols.item(loadid-1).phrase,  "type": screen.js().cols.item(loadid-1).type, "posit": screen.js().cols.item(loadid-1).position, "timeout": screen.js().cols.item(loadid-1).timeout, "notify": screen.js().cols.item(loadid-1).notify });
                bottombar.jm.append({})
                softload.restart();
                console.log("restarting with loadid " + loadid)
                // softload.start();
                console.log("running? " + softload.running);
            } else {
                loading.loadtext = "Loading columns (" + (loadid) + "/" + screen.js().cols.length + ")"
                tested++;
                console.log("not ready yet... tried " + tested + " times");
            }
        } else {
            softload.stop();
            console.log("done loading, do something interesting!!");
            loading.loadtext = "Done!";
            loading.state = "hidden";
            if (mainrowModel.count > 0) mainrow.contentX = 0;

        }
    }

    Timer {
        id: softload
        interval: 600;
        running: false; repeat: true
        onTriggered: loadNext();
    }
}

/*
// Show all added greetings
var rs = tx.executeSql('SELECT * FROM Greeting');

var r = ""
for(var i = 0; i < rs.rows.length; i++) {
    r += rs.rows.item(i).salutation + ", " + rs.rows.item(i).salutee + "\n"
}
text = r
 */
