import QtQuick 1.0

Item {
    property string inReplyTo: "";
    property alias tweetText: postInput.text;
    id: tweetBox
    x: -601
    y: 15
    z: 5
    Behavior on x {
        SpringAnimation { mass: 0.8; spring: 8; damping: 0.3 }
    }
    Rectangle {
        opacity: 0
        clip: true
        id: inputArea
        width: 600
        height: bottomSpacer.y + bottomSpacer.height
        //color: "grey"
        smooth: true
        // border.width: 1
        // border.color: "#cbcbcb"
        radius: 5
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#666" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        Behavior on opacity {
            NumberAnimation { duration: 500; }
        }
        Rectangle {
            x: 0; y: 0; z:1
            width: 599
            height: bottomSpacer.y + bottomSpacer.height - 1
            color: "transparent"
            border.width: 1
            border.color: "grey"

            radius: 5
        }
        Image { // moving background
            z: 0
            id: bgimage
            source: "images/leaves_mix_1.png"
            x: -140
            y: 140
            smooth: true
            Behavior on x {
                NumberAnimation { duration: 20000; }
            }
            Behavior on y {
                NumberAnimation { duration: 20000; }
            }
        }
        Text {
            id: label
            text: (140 - postInput.text.length) + " characters left"
            font.pointSize: 12
            x: 25
            y: 5
        }

        Rectangle {
            id: postInputContainer
            width: 558
            height: 90
            color: "white"
            border.width: 1
            border.color: "#cbcbcb"
            radius: 5
            x: 27; z: 1
            y: label.y + label.height + 3
            TextEdit {
                x: 5
                y: 2
                selectByMouse: true
                Keys.onReturnPressed: tweetBox.sendPost();
                Keys.onEnterPressed: tweetBox.sendPost();
                font.pointSize: 15
                id: postInput
                width: parent.width - 10
                height: parent.height - 4
                wrapMode: TextEdit.Wrap;
            }
        }
        Image {
            x: 16
            y: label.y + label.height + 30
            z: 2
            source: "images/tip.png"
        }

        NewButton {
            useimg: false
            x: parent.width - 5 - width
            y: postInputContainer.y + postInputContainer.height + 5
            text: "Send"
            onClicked: tweetBox.sendPost()
            id: postButton
        }

/*        NewButton { //met.al is temporarily offline
            useimg: false
            x: postButton.x - 5 - width
            y: postInputContainer.y + postInputContainer.height + 5
            text: "met.al"
            onClicked: tweetBox.shortenUrls("met.al");
            id: metalButton
        }
*/
        NewButton {
            useimg: false
            x: postButton.x - 3 - width
            y: postInputContainer.y + postInputContainer.height + 5
            text: "is.gd"
            onClicked: tweetBox.shortenUrls("is.gd");
            id: isgdButton
        }

        Rectangle {
            id: bottomSpacer;
            y: postButton.y + postButton.height
            height: 5
            color: "transparent"
        }
    }
    Rectangle {
        id: dragArea
        width: 60
        height: 50
        //color: "grey"
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#666" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        smooth: true

        border.width: 1
        border.color: "grey"
        radius: 10
        x: inputArea.x + inputArea.width - 5
        y: inputArea.y + 10
        NewButton {
            anchors.centerIn: parent
            id: dragbutton
            z:2
            flat: true
            useimgsize:  true
            bsource: 'images/twitterbird_40x40.png'
            onClicked: {
                if (tweetBox.state != "open") {
                    tweetBox.state = "open"
                    columnBox.state = "closed"
                    console.log("Opened");
                } else {
                    tweetBox.state = "closed";
                    console.log("Closed");
                }
            }
            button.drag.axis: Drag.XAxis
            button.drag.target: tweetBox


            onReleased: {
                if (button.drag.active == true) {
                    console.log("dragging tweetBox")
                    console.log("state = " + tweetBox.state)
                    console.log("x = " + tweetBox.x)
                    if (tweetBox.state != "closed") {
                        if (tweetBox.x < 0) {
                            tweetBox.state = "closed"
                        } else {
                            tweetBox.state = "move"
                            tweetBox.state = "open"
                            columnBox.state = "closed"

                        }
                    } else {
                        if (tweetBox.x > -541) {
                            tweetBox.state = "open"
                            columnBox.state = "closed"
                        } else {
                            tweetBox.state = "move"
                            tweetBox.state = "closed"
                        }
                    }
                }
            }
        }
    }

    states: [
        State {
            name: "closed"
            PropertyChanges { target: tweetBox; x: -601 }
            PropertyChanges { target: inputArea; opacity: 0 }
            PropertyChanges { target: bgimage; x: -140; y: 140 }
        },

        State {
            name: "open"
            PropertyChanges { target: tweetBox; x: 60 }
            PropertyChanges { target: inputArea; opacity: 1 }
            PropertyChanges { target: bgimage; x: 0; y: 0 }
         },
        State {
            name: "move"
            when: dragbutton.button.drag.active == true
            PropertyChanges { target: inputArea; opacity: 1 }
        }
    ]

    function sendPost() {
        console.log ("sendPost clicked with content \"" + postInput.text + "\"");
        tweetBox.state = "closed"
        screen.js().sendTweet(postInput.text, [["in_reply_to_status_id",inReplyTo]]);
        postInput.text = ""
        inReplyTo = "";
        return true
    }

    function shortenUrls(shortener) {
        postInput.text = screen.js().shortenUrl(postInput.text, shortener);
    }
}
