import QtQuick 1.0

Item {
    id: authBox
    x: -201
    y: 200
    z: 5
    Behavior on x {
        SpringAnimation { mass: 0.8; spring: 8; damping: 0.3 }
    }
    Rectangle {
        id: inputArea
        width: 200
        height: bottomSpacer.y + bottomSpacer.height
        //color: "grey"

        smooth: true

        border.width: 1
        border.color: "grey"
        radius: 5
        gradient: boxgrad
        Gradient {
            id: boxgrad
            GradientStop { position: 0.0; color: "#666" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        Behavior on opacity {
            NumberAnimation { duration: 500; }
        }
        Text {
            id: label
            text: "Username"
            font.pointSize: 12
            x: 10
            y: 5
        }

        Rectangle {
            id: userInputContainer
            width: 170
            height: 24
            color: "white"
            border.width: 1
            border.color: "#cbcbcb"
            radius: 5
            x: 15
            y: label.y + label.height + 3
            TextInput {
                x: 5
                y: 2
                selectByMouse: true
                Keys.onReturnPressed: authBox.doLogin(userInput.text, passInput.text);
                Keys.onEnterPressed: authBox.doLogin(userInput.text, passInput.text);
                font.pointSize: 12
                id: userInput
                width: parent.width - 10
                height: 24
            }
        }
        Text {
            id: label2
            text: "Password"
            font.pointSize: 12
            x: 10
            y: userInputContainer.y + userInputContainer.height + 5
        }

        Rectangle {
            id: passInputContainer
            width: 170
            height: 24
            color: "white"
            border.width: 1
            border.color: "#cbcbcb"
            radius: 5
            x: 15
            y: label2.y + label2.height + 3
            TextInput {
                x: 5
                y: 2
                selectByMouse: true
                Keys.onReturnPressed: authBox.doLogin(userInput.text, passInput.text);
                Keys.onEnterPressed: authBox.doLogin(userInput.text, passInput.text);
                font.pointSize: 12
                id: passInput
                echoMode: TextInput.Password
                width: parent.width - 10
                height: 24
            }
        }

        NewButton {
            useimg: false
            x: parent.width - 5 - width
            y: passInputContainer.y + passInputContainer.height + 5
            text: "Login"
            onClicked: authBox.doLogin(userInput.text, passInput.text)
            id: postButton
        }

/*        Button {
            x: postButton.x - 5 - width
            y: passInputContainer.y + passInputContainer.height + 5
            text: "Test info"
            onClicked: Notty.notify("Tweedsuit", "Yeah, it works :)");
            id: testButton
        } */
        Rectangle {
            id: bottomSpacer
            y: postButton.y + postButton.height
            height: 5
            color: "transparent"
        }
    }
    Rectangle {
        id: dragArea
        width: 60
        height: 50
        //color: "grey"
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#666" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        smooth: true

        border.width: 1
        border.color: "grey"
        radius: 10
        x: inputArea.x + inputArea.width - 5
        y: inputArea.y + 10
        NewButton {
            anchors.centerIn: parent
            id: dragbutton
            z:2
            flat: true
            useimgsize:  true
            bsource: oauth.authorized ? "images/user_auth.png" : "images/user_noauth.png";
            onClicked: {
                if (authBox.state != "open") {
                    authBox.state = "open"
                    console.log("Opened");
                } else {
                    authBox.state = "closed";
                    console.log("Closed");
                }
            }
            button.drag.axis: Drag.XAxis
            button.drag.target: authBox


            onReleased: {
                if (button.drag.active == true) {
                    if (authBox.state != "closed") {
                        if (authBox.x < 0) {
                            authBox.state = "closed"
                        } else {
                            authBox.state = "move"
                            authBox.state = "open"

                        }
                    } else {
                        if (authBox.x > -541) {
                            authBox.state = "open"
                        } else {
                            authBox.state = "move"
                            authBox.state = "closed"
                        }
                    }
                }
            }
        }
    }

    states: [
        State {
            name: "closed"
            PropertyChanges { target: authBox; x: -201 }
            PropertyChanges { target: inputArea; opacity: 0 }
        },

        State {
            name: "open"
            PropertyChanges { target: authBox; x: 200 }
            PropertyChanges { target: inputArea; opacity: 1 }
         },
        State {
            name: "move"
            when: dragbutton.button.drag.active == true
            PropertyChanges { target: inputArea; opacity: 1 }
        }
    ]
    function doLogin(username, password) {
        console.log ("Logging in with user " + username)
        storage.storeAuth(username, password);
        console.log("Stored user " + username);
        authBox.state = "closed"
        mainrowModel.clear();
        oauth.token = "";
        oauth.secret = "";
        oauth.username = username;
        oauth.password = password;
        oauth.authorized = false;
        console.log("so far so good...");
        oauth.beginAuthentication();

        return true
    }
}
