#!/usr/bin/env python
# -*- coding: utf-8 -*-

# TV-B-Gone for N900
# Copyright (C) 2010 Simon Budig  <simon@budig.de>
#
# Codes scanned by Limor Fried & Mitch Altman for the "TV-B-Gone Kit" project.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  A copy of the GNU General Public License is available at
#  http://www.fsf.org/licenses/gpl.txt, you can also write to the
#  Free Software  Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.

import os, fcntl, struct, time, math
import gobject, cairo, gtk, gconf
import hildon, hildondesktop, osso

GCONFPATH = "/apps/Maemo/budig.de/TVBGone"

# Collection of shutdown codes for various TV models.
TVBGoneCodes = {
   "Europe" : [
      # code EU 0
      [ 35714, "510040000000000031026100400000000000310",
        [(430, 470), (430, 910), (430, 83240), (880, 470), (1330, 1330), (2640, 900), (2640, 910)]],
      # code EU 1
      [ 30303, "011111111143261111115326111111",
        [(470, 2650), (510, 540), (510, 1080), (510, 2630), (510, 20530), (510, 116470), (1000, 1090)]],
      # code EU 2
      [ 33333, "0122111222123112211122212",
        [(430, 2060), (460, 2040), (460, 4560), (460, 34880)]],
      # code EU 3
      [ 38400, "3202020020001320202002000",
        [(600, 600), (600, 27000), (1200, 600), (2400, 600)]],
      # code EU 4
      [ 37037, "301000000000001000000000100000000101111001011110124010000000000010000000001000000001011110010111101",
        [(440, 450), (440, 1310), (440, 74620), (3460, 1760), (3460, 1780)]],
      # code EU 5
      [ 38610, "011111221211121421111211212221232111112212111214211112112122212",
        [(240, 1900), (250, 800), (250, 1900), (250, 41990), (250, 47990)]],
      # code EU 6
      [ 38462, "4111000001110000001000000101111112411100000111000000100000010111111",
        [(530, 630), (530, 1720), (530, 44720), (540, 0), (4550, 4680)]],
      # code EU 7
      [ 38462, "311000000111010002110000001110100021100000011101000",
        [(500, 540), (500, 1590), (500, 23070), (8380, 4220)]],
      # code EU 8
      [ 38462, "5000010101111010111101000000101112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code EU 9
      [ 35714, "04111111214314111111214",
        [(880, 900), (880, 910), (880, 1810), (880, 89760), (1770, 910)]],
      # code EU 10
      [ 38610, "5000000101111110101001000101101112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code EU 11
      [ 38462, "4100011001001001011000110001110012535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code EU 12
      [ 33445, "0011000111012001100011101",
        [(460, 2060), (460, 4590), (460, 34470)]],
      # code EU 13
      [ 38462, "311011110000000010000111111000000001111111123110111100000000100001111110000000011111111",
        [(530, 590), (530, 1710), (530, 23020), (8950, 4490)]],
      # code EU 14
      [ 38462, "4001010002101010003400101000210101000",
        [(480, 520), (480, 1600), (480, 4000), (480, 23350), (7990, 4000)]],
      # code EU 15
      [ 38462, "301010101101010100011100011000111240101010110101010001110001100011124010101011010101000111000110001112401010101101010100011100011000111",
        [(530, 540), (530, 1560), (530, 25420), (8510, 4250), (8530, 4240)]],
      # code EU 16
      [ 33333, "122000200200000032220002002000000",
        [(280, 920), (280, 2130), (280, 2140), (280, 27710)]],
      # code EU 17
      [ 33333, "01222122212321222122212",
        [(150, 8440), (160, 5570), (160, 8440), (160, 52240)]],
      # code EU 18
      [ 38462, "5000111001110001100111000110001112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code EU 19
      [ 38462, "4010000002011100003401000000201110000",
        [(500, 540), (500, 1580), (500, 4180), (500, 24430), (8430, 4180)]],
      # code EU 20
      [ 35714, "020202000000000130202020000000001",
        [(480, 3010), (480, 6510), (480, 10010), (480, 30010)]],
      # code EU 21
      [ 38462, "4110000010101111000010000111011112535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code EU 22
      [ 38462, "5110010100011010111101000000101112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code EU 23
      [ 38462, "4000110000001100000000011111111002535",
        [(530, 600), (530, 1750), (530, 44630), (530, 94530), (8920, 4500), (8950, 2250)]],
      # code EU 24
      [ 38462, "5000111001110001100001000111101112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code EU 25
      [ 31250, "21600043170005317000",
        [(490, 520), (490, 1020), (490, 2500), (490, 2520), (490, 23770), (490, 120090), (1000, 520), (1000, 1020)]],
      # code EU 26
      [ 38462, "11111000100211111000100",
        [(140, 4910), (140, 7430), (140, 49260)]],
      # code EU 27
      [ 38462, "5010101011010101010100011010111002636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code EU 28
      [ 30303, "011111111143216211115321621111",
        [(470, 2670), (500, 550), (500, 1100), (500, 2650), (500, 20550), (500, 121170), (1000, 570)]],
      # code EU 29
      [ 34483, "216000000000000431061000700000531061000700000",
        [(500, 500), (500, 990), (500, 2510), (500, 2520), (500, 14450), (500, 110140), (1020, 490), (1020, 980)]],
      # code EU 30
      [ 38462, "5001000001101111100010000111011112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code EU 31
      [ 38462, "311111000111010112111110001110101121111100011101011",
        [(530, 530), (530, 1600), (530, 16970), (8380, 4220)]],
      # code EU 32
      [ 33333, "0122111222113112211122211",
        [(490, 2050), (490, 2060), (490, 4560), (490, 36900)]],
      # code EU 33
      [ 38462, "0222113122211",
        [(480, 1500), (500, 1490), (500, 3470), (500, 29360)]],
      # code EU 34
      [ 38462, "5000110001110011100010000111011112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code EU 35
      [ 38462, "5100011100111000100010000111011112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code EU 36
      [ 38462, "10111100000210111100000",
        [(140, 4910), (140, 7430), (140, 51780)]],
      # code EU 37
      [ 0, "0011120011",
        [(30, 10020), (30, 14950), (30, 30590)]],
      # code EU 38
      [ 40161, "12222002200322222002200",
        [(130, 4450), (130, 6740), (130, 6750), (130, 45830)]],
      # code EU 39
      [ 35714, "301101001010010010110101124011010010100100101101011",
        [(850, 890), (850, 2640), (850, 34020), (3470, 3500), (3480, 3500)]],
      # code EU 40
      [ 33333, "031313122221141313131222211",
        [(460, 3000), (490, 2980), (490, 6480), (490, 9970), (490, 30560)]],
      # code EU 41
      [ 38462, "4000000011111011001010000101011112535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code EU 42
      [ 41667, "0",
        [(10370, 42160), (10400, 0)]],
      # code EU 43
      [ 38462, "5000100101110110100000000111111112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code EU 44
      [ 41667, "011232112",
        [(1520, 4710), (1540, 1560), (1540, 4690), (1540, 29470)]],
      # code EU 45
      [ 34602, "011222231112222",
        [(150, 4930), (160, 4930), (160, 6980), (160, 14140)]],
      # code EU 46
      [ 0, "1001021001021001",
        [(30, 4960), (30, 7450), (30, 14880)]],
      # code EU 47
      [ 38462, "4000000011101111011001000001101112535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code EU 48
      [ 38462, "401110000011100000010100011010111251351",
        [(550, 550), (550, 1670), (550, 45770), (550, 95060), (4480, 4450), (4500, 4440)]],
      # code EU 49
      [ 33333, "30000000000111111111110240000000000111111111110",
        [(910, 880), (910, 2670), (910, 36210), (3610, 3580), (3610, 3590)]],
      # code EU 50
      [ 38462, "301010001010010101110101124010100010100101011101011",
        [(840, 880), (840, 2610), (840, 33600), (3470, 3470), (3470, 3480)]],
      # code EU 51
      [ 31250, "01222122212321222122212",
        [(160, 8380), (170, 5580), (170, 8390), (170, 63280)]],
      # code EU 52
      [ 34483, "021222231212222",
        [(150, 4930), (160, 4930), (160, 6980), (160, 14140)]],
      # code EU 53
      [ 31250, "2001504300150",
        [(490, 530), (490, 1040), (490, 2620), (490, 2640), (490, 80300), (1000, 1030)]],
      # code EU 54
      [ 38462, "4000000010111111000011000111001112535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code EU 55
      [ 38462, "021",
        [(1120, 1070), (1130, 1070), (6770, 27660)]],
      # code EU 56
      [ 38462, "4000000011010111001010000101011112535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code EU 57
      [ 41667, "021",
        [(3100, 6130), (3100, 6140), (6220, 83120)]],
      # code EU 58
      [ 38462, "021111212122112232211112121221122",
        [(500, 1580), (530, 510), (530, 1560), (530, 21800)]],
      # code EU 59
      [ 35714, "04111124111314111124111",
        [(880, 900), (880, 910), (880, 1810), (880, 89760), (1770, 910)]],
      # code EU 60
      [ 38462, "021121212122112232211212121221122",
        [(500, 1580), (530, 510), (530, 1560), (530, 21800)]],
      # code EU 61
      [ 38462, "4000000011110101001010000101011112535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code EU 62
      [ 30395, "0111111111431121627531121627",
        [(470, 2670), (500, 550), (500, 1100), (500, 2650), (500, 20550), (500, 121170), (1000, 570), (1000, 1120)]],
      # code EU 63
      [ 30303, "011111111143111216115311121611",
        [(470, 2670), (500, 550), (500, 1100), (500, 2650), (500, 20550), (500, 121170), (1000, 1120)]],
      # code EU 64
      [ 38462, "411010000110100000101000010101111250350",
        [(550, 550), (550, 1670), (550, 45770), (550, 95060), (4480, 4450), (4500, 4440)]],
      # code EU 65
      [ 38462, "10010210010",
        [(940, 4730), (940, 7280), (1020, 16370)]],
      # code EU 66
      [ 38610, "011111111143211116115321111611",
        [(490, 2630), (500, 540), (500, 1080), (500, 2630), (500, 20290), (500, 101990), (1000, 1100)]],
      # code EU 67
      [ 0, "0011111000120011111000",
        [(40, 4990), (40, 7500), (40, 49990)]],
      # code EU 68
      [ 0, "0110111000120110111000",
        [(40, 4990), (40, 7500), (40, 49990)]],
      # code EU 69
      [ 38462, "10111010111210111010111",
        [(140, 4910), (140, 7430), (140, 44220)]],
      # code EU 70
      [ 0, "1111101110121111101110",
        [(50, 5680), (50, 8540), (50, 49990)]],
      # code EU 71
      [ 34483, "012111131121111",
        [(150, 4930), (160, 4930), (160, 6980), (160, 14140)]],
      # code EU 72
      [ 35714, "0111111112143111111111214",
        [(880, 890), (880, 900), (880, 1790), (880, 89770), (1770, 900)]],
      # code EU 73
      [ 0, "0011101110120011101110",
        [(60, 5660), (60, 8510), (60, 54740)]],
      # code EU 74
      [ 38462, "02222122212322222122212",
        [(140, 8430), (160, 5550), (160, 8410), (160, 49110)]],
      # code EU 75
      [ 30303, "011111111143112162115311216211",
        [(470, 2670), (500, 550), (500, 1100), (500, 2650), (500, 20550), (500, 121170), (1000, 570)]],
      # code EU 76
      [ 0, "21000031000",
        [(60, 9250), (60, 13390), (60, 20980), (60, 27870)]],
      # code EU 77
      [ 38462, "3000000011100011011110000000011112400000001110001101111000000001111",
        [(530, 590), (530, 1700), (530, 43590), (8920, 4480), (8930, 4480)]],
      # code EU 78
      [ 38462, "3000000010010011010010010011011012400000001001001101001001001101101",
        [(550, 570), (550, 1670), (550, 44160), (8950, 4480), (8970, 4470)]],
      # code EU 79
      [ 38462, "0122112212111213212212112122212321221122121112132122121121222123212211221211121",
        [(260, 1850), (270, 800), (270, 1850), (270, 42490)]],
      # code EU 80
      [ 40000, "3010101011010101011011000001001112401010101101010101101100000100111",
        [(510, 560), (510, 1620), (510, 28420), (8480, 4300), (8500, 4290)]],
      # code EU 81
      [ 33333, "03434041404230404044404",
        [(160, 5590), (160, 8470), (160, 59000), (170, 5590), (170, 8470)]],
      # code EU 82
      [ 38462, "12222200000322222200000",
        [(160, 4840), (160, 7380), (160, 7390), (160, 47950)]],
      # code EU 83
      [ 38462, "4110110002111110003411011000211111000",
        [(480, 520), (480, 1600), (480, 4000), (480, 21200), (7990, 4000)]],
      # code EU 84
      [ 33333, "21303133013431330133010",
        [(160, 8510), (170, 5540), (170, 8500), (170, 8510), (170, 48470)]],
      # code EU 85
      [ 38462, "11111100000211111100000",
        [(140, 4910), (140, 7430), (140, 51260)]],
      # code EU 86
      [ 38462, "10111110100210111110100",
        [(140, 4910), (140, 7430), (140, 48740)]],
      # code EU 87
      [ 38462, "4101010002101010003410101000210101000",
        [(480, 520), (480, 1600), (480, 4000), (480, 23350), (7990, 4000)]],
      # code EU 88
      [ 0, "3000021000001343000021000001",
        [(30, 90), (30, 190), (30, 290), (30, 390), (30, 99680)]],
      # code EU 89
      [ 38462, "20000001000002320000001000002",
        [(150, 1380), (150, 4460), (150, 6050), (150, 65650)]],
      # code EU 90
      [ 40000, "102020000032020200000",
        [(480, 500), (480, 1480), (480, 1490), (480, 14240)]],
      # code EU 91
      [ 35714, "0111212221",
        [(870, 6390), (880, 2750), (880, 6390)]],
      # code EU 92
      [ 0, "3010021000000343010021000000",
        [(30, 80), (30, 180), (30, 240), (30, 380), (30, 99690)]],
      # code EU 93
      [ 34483, "022222231222222",
        [(150, 4930), (160, 4930), (160, 6980), (160, 14140)]],
      # code EU 94
      [ 38462, "01112113111124651112113111124",
        [(130, 6080), (140, 1410), (140, 2960), (140, 4510), (140, 6060), (140, 6080), (140, 62070)]],
      # code EU 95
      [ 34483, "012122231121222",
        [(150, 4930), (160, 4930), (160, 6980), (160, 14140)]],
      # code EU 96
      [ 0, "20000001000023201111010000",
        [(30, 80), (30, 180), (30, 280), (30, 127310)]],
      # code EU 97
      [ 35714, "215000000000000321051000000060421051000000060",
        [(460, 530), (460, 1060), (460, 2600), (460, 15020), (460, 109620), (930, 530), (930, 1060)]],
      # code EU 98
      [ 0, "20000010000023201111100000",
        [(30, 80), (30, 180), (30, 280), (30, 127310)]],
      # code EU 99
      [ 38462, "11111100001211111100001",
        [(140, 4910), (140, 7430), (140, 46740)]],
      # code EU 100
      [ 38462, "10111110000210111110000",
        [(140, 4910), (140, 7430), (140, 51260)]],
      # code EU 101
      [ 34483, "02212122212322212122212",
        [(440, 8150), (450, 5280), (450, 8150), (450, 50000)]],
      # code EU 102
      [ 38462, "10101000000210101000000",
        [(140, 4910), (140, 7430), (140, 58810)]],
      # code EU 103
      [ 38610, "4101000010110001001001000101101112535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code EU 104
      [ 38462, "0261111111111111432162111177625321621111776253216211117762",
        [(480, 2460), (500, 470), (500, 940), (500, 2450), (500, 14880), (500, 109700), (1000, 470), (1000, 940)]],
      # code EU 105
      [ 33333, "30404240424144040204020",
        [(160, 8470), (160, 59000), (170, 5590), (170, 8460), (170, 8470)]],
      # code EU 106
      [ 38462, "10111110011210111110011",
        [(140, 4910), (140, 7430), (140, 46220)]],
      # code EU 107
      [ 38462, "012121111132121211111",
        [(240, 1850), (270, 780), (270, 1830), (270, 15420)]],
      # code EU 108
      [ 38462, "3101000001010000001000000101111112410100000101000000100000010111111",
        [(560, 550), (560, 1680), (560, 48500), (4470, 4530), (4480, 4530)]],
      # code EU 109
      [ 31250, "10500032060004206000",
        [(490, 520), (490, 2500), (490, 2520), (490, 23770), (490, 120090), (1000, 520), (1000, 1020)]],
      # code EU 110
      [ 38462, "400010000000100001111000000001111251351",
        [(550, 550), (550, 1670), (550, 50230), (550, 95060), (4480, 4450), (4500, 4440)]],
      # code EU 111
      [ 31250, "2150004315000",
        [(490, 530), (490, 1040), (490, 2620), (490, 2640), (490, 80300), (1000, 1030)]],
      # code EU 112
      [ 30303, "011111111143216121115321612111",
        [(470, 2670), (500, 550), (500, 1100), (500, 2650), (500, 20550), (500, 121170), (1000, 570)]],
      # code EU 113
      [ 58824, "4111100111011000011000100231111001110110000110001002311110011101100001100010",
        [(480, 980), (480, 1960), (970, 8360), (3950, 3880), (19310, 3890)]],
      # code EU 114
      [ 0, "2000000100000232000000100000",
        [(30, 90), (30, 310), (30, 420), (30, 109570)]],
      # code EU 115
      [ 31250, "1040003204000",
        [(490, 530), (490, 2620), (490, 2640), (490, 80300), (1000, 1030)]],
      # code EU 116
      [ 34483, "02222122212322222122212",
        [(440, 8150), (450, 5280), (450, 8150), (450, 47130)]],
      # code EU 117
      [ 38462, "10101010000210101010000",
        [(140, 4910), (140, 7430), (140, 54300)]],
      # code EU 118
      [ 38462, "022222222221111211111111111111111111221132222222222211112111111111111111111112211",
        [(190, 780), (210, 270), (210, 770), (210, 37850), (220, 0)]],
      # code EU 119
      [ 38462, "310000111100001111000011124100001111000011110000111",
        [(840, 880), (840, 2610), (840, 33600), (3470, 3470), (3470, 3480)]],
      # code EU 120
      [ 38462, "011222222222111122111111111111111111221132112222222221111221111111111111111112211",
        [(190, 780), (210, 270), (210, 770), (210, 37850), (220, 0)]],
      # code EU 121
      [ 40000, "12222200002322222200002",
        [(130, 4900), (130, 7410), (130, 7420), (130, 54430)]],
      # code EU 122
      [ 38462, "4001010002111110003400101000211111000",
        [(500, 540), (500, 1580), (500, 4070), (500, 21530), (8430, 4070)]],
      # code EU 123
      [ 38462, "4110000010101111000010000111011112511000001010111100001000011101111",
        [(550, 560), (550, 1680), (550, 39290), (560, 0), (8820, 4540), (8840, 4520)]],
      # code EU 124
      [ 38462, "5000000001111111100000000111111112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code EU 125
      [ 38462, "10101000111210101000111",
        [(140, 4910), (140, 7430), (140, 51260)]],
      # code EU 126
      [ 41667, "0134213",
        [(1520, 4710), (1540, 1560), (1540, 4690), (1540, 7820), (1540, 29470)]],
      # code EU 127
      [ 38462, "21600000000000004310610000770753106100007707",
        [(500, 500), (500, 990), (500, 2510), (500, 2520), (500, 14490), (500, 110140), (1020, 490), (1020, 980)]],
      # code EU 128
      [ 38462, "21600000000000004310610000761753106100007617",
        [(500, 500), (500, 990), (500, 2510), (500, 2520), (500, 14490), (500, 110140), (1020, 490), (1020, 980)]],
      # code EU 129
      [ 38462, "11111111100211111111100",
        [(140, 4910), (140, 7430), (140, 41700)]],
      # code EU 130
      [ 0, "0011110000120011110000",
        [(40, 4990), (40, 7500), (40, 49990)]],
      # code EU 131
      [ 38462, "11111110010211111110010",
        [(140, 4910), (140, 7430), (140, 44220)]],
      # code EU 132
      [ 40000, "10000022200320000022200",
        [(130, 4900), (130, 7410), (130, 7420), (130, 59390)]],
      # code EU 133
      [ 0, "1110101110121110101110",
        [(60, 5660), (60, 8510), (60, 51880)]],
      # code EU 134
      [ 38462, "5000000001111111110000000011111112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code EU 135
      [ 35714, "051125121531511251215",
        [(860, 910), (870, 900), (870, 1800), (870, 88680), (880, 0), (1740, 900)]],
      # code EU 136
      [ 0, "0011120011",
        [(40, 10360), (40, 15070), (40, 30050)]],
      # code EU 137
      [ 0, "31111112111113431111112111113",
        [(0, 0), (140, 1410), (140, 4520), (140, 6070), (140, 63100)]],
   ],

   "North America" : [
      # code NA 0
      [ 38400, "3202020020001320202002000",
        [(600, 600), (600, 27000), (1200, 600), (2400, 600)]],
      # code NA 1
      [ 57143, "311110010101000001101010123111100101010000011010101",
        [(500, 1000), (500, 2000), (500, 8000), (4000, 4000)]],
      # code NA 2
      [ 37037, "301000000000001000000000100000000101111001011110124010000000000010000000001000000001011110010111101",
        [(420, 460), (420, 1330), (420, 75190), (3470, 1760), (3470, 1770)]],
      # code NA 3
      [ 38610, "011111221211121321111211212221232111112212111213211112112122212",
        [(260, 1850), (270, 800), (270, 1850), (270, 45490)]],
      # code NA 4
      [ 38610, "5000000101111110101001000101101112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code NA 5
      [ 35714, "04111111214314111111214",
        [(880, 900), (880, 910), (880, 1810), (880, 89760), (1770, 910)]],
      # code NA 6
      [ 38462, "3111000001110000001000000101111112411100000111000000100000010111111",
        [(500, 620), (500, 1720), (500, 45410), (4480, 4660), (4500, 4650)]],
      # code NA 7
      [ 39216, "023121231231233141231212312312331",
        [(490, 490), (490, 500), (490, 4100), (490, 5100), (490, 121070)]],
      # code NA 8
      [ 38462, "3100011100111000101010010101011012410001110011100010101001010101101",
        [(560, 580), (560, 1700), (560, 40110), (8980, 4500), (9000, 4490)]],
      # code NA 9
      [ 38462, "4111000010100010000000111111110002535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code NA 10
      [ 38462, "311000000111010002110000001110100021100000011101000",
        [(510, 550), (510, 1580), (510, 22860), (8410, 4190)]],
      # code NA 11
      [ 38462, "5000010101111010111101000000101112636",
        [(550, 550), (550, 1720), (550, 40390), (550, 93480), (560, 0), (8840, 4420), (8850, 2250)]],
      # code NA 12
      [ 38462, "310110101100001010010011124101101011000010100100111",
        [(810, 870), (810, 2540), (810, 32800), (3310, 3360), (3310, 3370)]],
      # code NA 13
      [ 38462, "40011100010000110001110111101001000101101112535",
        [(530, 550), (530, 1670), (530, 23040), (530, 93690), (8930, 4480), (8950, 4470)]],
      # code NA 14
      [ 38462, "5000001101111100111000000001111112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code NA 15
      [ 38462, "5010000101011110110000000011111112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code NA 16
      [ 34483, "111000100100000021110001001000000",
        [(280, 900), (280, 2110), (280, 25070)]],
      # code NA 17
      [ 40000, "5000111001110001101001000101101112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 18
      [ 38462, "301010101101010100011100011000111240101010110101010001110001100011124010101011010101000111000110001112401010101101010100011100011000111",
        [(510, 550), (510, 1610), (510, 25660), (8490, 4290), (8490, 4300)]],
      # code NA 19
      [ 38462, "300101000110001100000000000100001001000010100000024001010001100011000000000001000010010000101000000",
        [(400, 420), (400, 1240), (400, 46010), (3250, 1630), (3260, 1630)]],
      # code NA 20
      [ 38462, "5001000001101111100010000111011112636",
        [(600, 550), (600, 1630), (600, 40990), (600, 96980), (610, 0), (8980, 4610), (9000, 2300)]],
      # code NA 21
      [ 38462, "4001010002101010003400101000210101000",
        [(480, 520), (480, 1600), (480, 4000), (480, 23350), (7990, 4000)]],
      # code NA 22
      [ 38462, "4000110000001100000000011111111002535",
        [(530, 600), (530, 1750), (530, 44630), (530, 94530), (8920, 4500), (8950, 2250)]],
      # code NA 23
      [ 40000, "2201012012012201012013220101201201220101201",
        [(480, 520), (480, 4090), (480, 5040), (480, 104610)]],
      # code NA 24
      [ 38462, "3222202020001422220202000",
        [(580, 600), (580, 25690), (1180, 600), (2370, 600), (2380, 600)]],
      # code NA 25
      [ 38462, "311111110000000000001111124111111100000000000011111",
        [(840, 900), (840, 2640), (840, 34700), (3460, 3500), (3470, 3500)]],
      # code NA 26
      [ 39216, "023121233123123141231212331231231",
        [(490, 490), (490, 500), (490, 4100), (490, 5100), (490, 125820)]],
      # code NA 27
      [ 57143, "301110010101010001101010123011100101010100011010101",
        [(500, 1000), (500, 2000), (500, 8000), (4000, 4000)]],
      # code NA 28
      [ 38610, "30101011011000101230101011011000101",
        [(1180, 1210), (1180, 2710), (1180, 47500), (2580, 2710)]],
      # code NA 29
      [ 35842, "031111232141311112321",
        [(880, 900), (880, 910), (880, 1810), (1770, 910), (1770, 89760)]],
      # code NA 30
      [ 38462, "4000010101011010100000000111111112535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code NA 31
      [ 35842, "01411111214311411111214",
        [(880, 890), (880, 900), (880, 1790), (880, 89770), (1770, 900)]],
      # code NA 32
      [ 38462, "4000010101011010101000000101111112535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code NA 33
      [ 38462, "300101000110001100000000000100001010100010000000024001010001100011000000000001000010101000100000000",
        [(400, 430), (400, 1220), (400, 52970), (3340, 1560), (3360, 1550)]],
      # code NA 34
      [ 38462, "5000010101111010111111100000000112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code NA 35
      [ 41667, "011212121131112121211",
        [(960, 930), (970, 930), (970, 2870), (970, 34310)]],
      # code NA 36
      [ 37037, "0111212221",
        [(820, 5810), (840, 2500), (840, 5800), (850, 0)]],
      # code NA 37
      [ 41667, "2000101100",
        [(390, 2630), (1640, 1630), (5140, 1640)]],
      # code NA 38
      [ 40000, "5101010000101011101001000101101112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 39
      [ 40000, "010",
        [(1130, 1010), (6880, 27070)]],
      # code NA 40
      [ 40000, "0012001",
        [(1130, 1010), (1130, 2010), (1130, 27070)]],
      # code NA 41
      [ 76923, "3202020020001320202002000",
        [(580, 620), (580, 27460), (1170, 620), (2420, 620)]],
      # code NA 42
      [ 40000, "5110000010101111000010000111011112434",
        [(540, 650), (540, 1700), (540, 40990), (540, 86680), (8990, 2260), (8990, 4210)]],
      # code NA 43
      [ 40000, "01111311111211111311111",
        [(430, 1200), (430, 1210), (430, 34910), (1310, 450)]],
      # code NA 44
      [ 40000, "4111000000001111101000000101111112535",
        [(510, 510), (510, 1600), (510, 40960), (510, 95130), (4310, 4360), (8830, 2190)]],
      # code NA 45
      [ 38462, "401100000011000001111000000001111251351",
        [(580, 530), (580, 1670), (580, 44940), (580, 96790), (4550, 4490), (4560, 4490)]],
      # code NA 46
      [ 29412, "0261114321111153211111",
        [(510, 2770), (520, 530), (520, 1050), (520, 2770), (520, 25270), (520, 128090), (1030, 540)]],
      # code NA 47
      [ 40000, "5000010001111011111110111000010002434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 48
      [ 40000, "4000000001111111111110000000011112535",
        [(510, 510), (510, 1600), (510, 40960), (510, 95130), (4310, 4360), (8830, 2190)]],
      # code NA 49
      [ 45455, "0110010110",
        [(2740, 8540), (2740, 19860)]],
      # code NA 50
      [ 55556, "30000000000111111111110230000000000111111111110",
        [(800, 880), (800, 2540), (800, 37500), (3590, 3310)]],
      # code NA 51
      [ 40000, "5001000111101110000011000111001112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 52
      [ 40000, "5111011000001001101001000101101112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 53
      [ 55556, "02020201100001302020201100001",
        [(510, 2320), (510, 5120), (510, 7920), (510, 28830)]],
      # code NA 54
      [ 55556, "020202000111130202020001111",
        [(510, 2320), (510, 5120), (510, 7920), (510, 28830)]],
      # code NA 55
      [ 0, "20011101011023200111010110",
        [(30, 100), (30, 200), (30, 300), (30, 127780)]],
      # code NA 56
      [ 37175, "0222111",
        [(550, 1930), (570, 1920), (570, 3840), (580, 0)]],
      # code NA 57
      [ 40000, "0222113122211",
        [(450, 1480), (460, 1480), (460, 3510), (460, 27810)]],
      # code NA 58
      [ 33333, "43322010010022222",
        [(220, 1010), (220, 2190), (230, 1010), (230, 2190), (310, 2180)]],
      # code NA 59
      [ 40000, "5101101100100100100101000110101112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 60
      [ 40000, "5000001001111101110001000011101112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 61
      [ 40000, "5000001011111101011010000001011112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 62
      [ 40000, "5000101001110101111010000001011112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 63
      [ 40000, "5111111110000000011111100000000112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 64
      [ 57143, "300000011101111111100010023000000111011111111000100",
        [(500, 1000), (500, 2000), (500, 8000), (4000, 4000)]],
      # code NA 65
      [ 59172, "41111001110110000110001002311110011101100001100010023111100111011000011000100",
        [(480, 980), (480, 1970), (980, 8460), (3950, 3920), (19530, 3920)]],
      # code NA 66
      [ 38462, "30001011000200010110002000101100",
        [(380, 2760), (1650, 1540), (4150, 1550), (7420, 1540)]],
      # code NA 67
      [ 40000, "4000111111110000001000000101111112535",
        [(510, 510), (510, 1600), (510, 40960), (510, 95130), (4310, 4360), (8830, 2190)]],
      # code NA 68
      [ 40000, "20300300003130300300003",
        [(430, 1210), (430, 94370), (1300, 450), (1310, 450)]],
      # code NA 69
      [ 40000, "5000000001111111111010000001011112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 70
      [ 38462, "10000002002022023200000020020220",
        [(270, 760), (270, 1820), (270, 1830), (270, 31990)]],
      # code NA 71
      [ 55556, "0101100",
        [(370, 1810), (370, 2720)]],
      # code NA 72
      [ 40000, "5011000000110000000101000110101112434",
        [(540, 650), (540, 1700), (540, 40990), (540, 86680), (8990, 2260), (8990, 4210)]],
      # code NA 73
      [ 40000, "5010101011010101000000001111111102434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 74
      [ 40000, "5100010100111010100010000111011112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 75
      [ 41667, "300000010101011111101010124000000101010111111010101",
        [(510, 980), (510, 1940), (1020, 9310), (3900, 3900), (3900, 3910)]],
      # code NA 76
      [ 40000, "5011101101000100100101000110101112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 77
      [ 35714, "041211421431412114214",
        [(880, 890), (880, 900), (880, 1790), (880, 89770), (1770, 900)]],
      # code NA 78
      [ 38462, "200010110010000101100100001011001",
        [(400, 2750), (1600, 1540), (4800, 1550)]],
      # code NA 79
      [ 40000, "5010101011010101011100101000110102434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 80
      [ 0, "20011100100023200111001000",
        [(30, 100), (30, 200), (30, 300), (30, 127780)]],
      # code NA 81
      [ 40000, "012010120120122010130120101201201220101",
        [(480, 520), (480, 4090), (480, 5040), (480, 99780)]],
      # code NA 82
      [ 35714, "02411111125312411111125",
        [(880, 890), (880, 900), (880, 1790), (880, 88880), (1770, 900), (1770, 1790)]],
      # code NA 83
      [ 35714, "04111111214314111111214",
        [(880, 890), (880, 900), (880, 1790), (880, 89770), (1770, 900)]],
      # code NA 84
      [ 37037, "301000000000001000000100100000000101111001011010124010000000000010000001001000000001011110010110101",
        [(410, 430), (410, 1280), (410, 74760), (3360, 1710), (3380, 1690)]],
      # code NA 85
      [ 38462, "3100000000000100001002410000000000010000100",
        [(550, 600), (550, 1650), (550, 22840), (4450, 4370), (4480, 4360)]],
      # code NA 86
      [ 37175, "301010101010110101111000101001000011010001000101124010101010101101011110001010010000110100010001011",
        [(420, 460), (420, 1260), (420, 69890), (3470, 1760), (3470, 1770)]],
      # code NA 87
      [ 38462, "5000110001110011100010000111011112434",
        [(560, 690), (560, 1740), (560, 41650), (560, 95850), (8800, 2220), (8800, 4350)]],
      # code NA 88
      [ 38610, "4000010001011010011111000000001112535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code NA 89
      [ 38462, "5000100001110111101001000101101112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code NA 90
      [ 35714, "0412542143141254214",
        [(880, 900), (880, 910), (880, 1810), (880, 89760), (1770, 910), (1770, 1810)]],
      # code NA 91
      [ 58824, "311110011101100001100010023111100111011000011000100",
        [(480, 1000), (480, 2000), (480, 10500), (4000, 4000)]],
      # code NA 92
      [ 38462, "3101000001010000001000000101111112310100000101000000100000010111111",
        [(540, 560), (540, 1700), (540, 49270), (4510, 4470)]],
      # code NA 93
      [ 38462, "3011000010100000010010010011011012401100001010000001001001001101101",
        [(550, 570), (550, 1670), (550, 44000), (8950, 4480), (8970, 4470)]],
      # code NA 94
      [ 35714, "041121421431411214214",
        [(880, 900), (880, 910), (880, 1810), (880, 89760), (1770, 910)]],
      # code NA 95
      [ 38462, "400010000000100001101000000101111241341",
        [(560, 580), (560, 1740), (560, 45490), (560, 94480), (4400, 4460)]],
      # code NA 96
      [ 38462, "4010010001111111101110000100011112535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code NA 97
      [ 38462, "4110000011010101001000011101111002535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code NA 98
      [ 38462, "5000000001111111110001010011101012636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code NA 99
      [ 38462, "4000000001011110110000000011111112535",
        [(530, 560), (530, 1710), (530, 39500), (530, 95990), (8980, 4510), (9000, 2260)]],
      # code NA 100
      [ 35842, "022111211211111132221112112111111",
        [(430, 1710), (450, 600), (450, 1700), (540, 23010)]],
      # code NA 101
      [ 38462, "5000001101111100100000000111111112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code NA 102
      [ 40000, "310010100000101101011111024100101000001011010111110",
        [(860, 870), (860, 2580), (860, 33380), (3460, 3480), (3480, 3470)]],
      # code NA 103
      [ 38462, "400010000000100001111000000001111251351",
        [(580, 530), (580, 1670), (580, 44940), (580, 96790), (4550, 4490), (4560, 4490)]],
      # code NA 104
      [ 40000, "5100011100111000100010000111011112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 105
      [ 40000, "5110000010011111011111111000000002434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 106
      [ 40000, "4000100001110111111110000000011112535",
        [(510, 510), (510, 1600), (510, 40960), (510, 95130), (4310, 4360), (8830, 2190)]],
      # code NA 107
      [ 38462, "400000000000000001111000000001111251351",
        [(580, 530), (580, 1670), (580, 44940), (580, 96790), (4550, 4490), (4560, 4490)]],
      # code NA 108
      [ 38462, "401101000011010001111000000001111251351",
        [(580, 530), (580, 1670), (580, 44940), (580, 96790), (4550, 4490), (4560, 4490)]],
      # code NA 109
      [ 40000, "5000001011111101001010000101011113424",
        [(580, 610), (580, 2110), (580, 95820), (730, 41640), (8830, 2110), (10500, 4940)]],
      # code NA 110
      [ 40161, "5110000010011111000010000111011112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 111
      [ 40000, "4111111110000000011110000000011112535",
        [(510, 510), (510, 1600), (510, 40960), (510, 95130), (4310, 4360), (8830, 2190)]],
      # code NA 112
      [ 38462, "5100000000111111110000000011111112636",
        [(550, 570), (550, 1700), (550, 39490), (550, 96230), (560, 0), (8980, 4530), (9000, 2260)]],
      # code NA 113
      [ 40000, "3000000010001011010010010011011012400000001000101101001001001101101",
        [(560, 540), (560, 1660), (560, 39450), (8960, 4420), (8960, 4430)]],
      # code NA 114
      [ 40000, "4101010002101010003510101000210101000",
        [(440, 500), (440, 1470), (440, 4470), (440, 22360), (7910, 3980), (7930, 3970)]],
      # code NA 115
      [ 40000, "301010001010010101110101124010100010100101011101011",
        [(810, 860), (810, 2960), (810, 33490), (3280, 3310), (3290, 3310)]],
      # code NA 116
      [ 40000, "5000010001111011110001000011101112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 117
      [ 41667, "4100000002011100003510000000201110000",
        [(490, 540), (490, 1580), (490, 4200), (490, 24460), (8190, 4200), (8210, 4190)]],
      # code NA 118
      [ 40000, "4111011110001000011110000000011112535",
        [(510, 510), (510, 1600), (510, 40960), (510, 95130), (4310, 4360), (8830, 2190)]],
      # code NA 119
      [ 55556, "5001000001101111100010000111011112434",
        [(550, 630), (550, 1710), (550, 40940), (550, 95080), (8810, 2190), (8810, 4380)]],
      # code NA 120
      [ 40000, "5001100001100111111111000000001112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 121
      [ 40000, "5000010001111011100010000111011112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 122
      [ 52632, "40000000000111111111001240000000000111111111001",
        [(800, 950), (800, 2490), (800, 38670), (810, 0), (3290, 3220)]],
      # code NA 123
      [ 40000, "5000111001110001100111000110001112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 124
      [ 40000, "4000011001111001100000000111111112535",
        [(540, 560), (540, 1510), (540, 40920), (540, 86770), (9000, 4210), (9010, 2260)]],
      # code NA 125
      [ 55556, "5000111001110001101001000101101112434",
        [(550, 630), (550, 1710), (550, 40940), (550, 95080), (8810, 2190), (8810, 4380)]],
      # code NA 126
      [ 40000, "5101000010101111000010000111011112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 127
      [ 25641, "0123112",
        [(1140, 1000), (1150, 1000), (1150, 2000), (1150, 27060)]],
      # code NA 128
      [ 40000, "300010100000111101011111024000101000001111010111110",
        [(860, 870), (860, 2580), (860, 33380), (3460, 3480), (3480, 3470)]],
      # code NA 129
      [ 40000, "5111111110000000000010000111011112434",
        [(560, 570), (560, 1750), (560, 41500), (560, 94990), (8980, 2270), (8980, 4490)]],
      # code NA 130
      [ 37037, "310000101110101111010001024100001011101011110100010",
        [(880, 900), (880, 2580), (880, 22470), (3580, 3490), (3580, 3500)]],
      # code NA 131
      [ 40000, "5001010001101011111011000001001112434",
        [(540, 650), (540, 1700), (540, 40990), (540, 86680), (8990, 2260), (8990, 4210)]],
      # code NA 132
      [ 83333, "0202020000000113020202000000011",
        [(280, 1060), (280, 2380), (280, 3700), (280, 11730)]],
      # code NA 133
      [ 41667, "02222111221322222111221",
        [(130, 7410), (150, 4890), (150, 7400), (170, 46410), (180, 0)]],
      # code NA 134
      [ 40000, "3011000011010000011110000000011112401100001101000001111000000001111",
        [(560, 540), (560, 1660), (560, 39450), (8960, 4420), (8960, 4430)]],
      # code NA 135
      [ 38462, "300111110000001100000111111000000001111111124001111100000011000001111110000000011111111",
        [(530, 590), (530, 1710), (530, 23010), (8920, 4500), (8950, 4480)]],
      # code NA 136
      [ 38610, "411011110000000010000111111000000001111111125110111100000000100001111110000000011111111",
        [(530, 590), (530, 1710), (530, 23010), (550, 0), (8920, 4500), (8950, 4480)]],
   ],
}


# main class implementing the hildon desktop applet

class TVBGone (hildondesktop.HomePluginItem):
   def __init__ (self):
      hildondesktop.HomePluginItem.__init__ (self)

      os.system ("sudo /sbin/modprobe lirc_rx51")
      self.set_settings (True)
      self.connect ('show-settings', self.settings_dialog)
      self.connect ('button-release-event', self.button_release_event)
      self.set_size_request (90, 90)
      self.index = 0
      self.progress = 0.0
      self.timeout = None
      self.lircdev = None
      self.starttime = 0
      # fix up codes for N900's poor driver by adjusting the times
      for codelist in TVBGoneCodes.values():
         for c in codelist:
            timings = [(max (5, pulse - 141),
                        max (5, gap - 104)) for pulse, gap in c[2]]
            c[2] = timings

      conf_client = gconf.client_get_default ()
      conf_client.add_dir (GCONFPATH, gconf.CLIENT_PRELOAD_NONE)
      self.codeid = conf_client.get_string (GCONFPATH + "/codeid")
      if not TVBGoneCodes.has_key (self.codeid):
         self.codeid = "Europe"
      self.codes = TVBGoneCodes[self.codeid]


   def do_realize (self):
      self.set_colormap (self.get_screen ().get_rgba_colormap ())
      self.set_app_paintable (True)
      hildondesktop.HomePluginItem.do_realize (self)


   def do_expose_event (self, event):
      a = event.area
      cr = self.window.cairo_create()

      # rounded rectangle as a base
      r = min (15, a.width / 2, a.height / 2)
      cr.move_to (0, r)
      cr.arc (r, r, r, math.pi, 1.5 * math.pi)
      cr.line_to (a.width - r, 0)
      cr.arc (a.width - r, r, r, 1.5 * math.pi, 0)
      cr.line_to (a.width, a.height - r)
      cr.arc (a.width - r, a.height - r, r, 0, 0.5 * math.pi)
      cr.line_to (a.width - r, a.height)
      cr.arc (r, a.height - r, r, 0.5 * math.pi, math.pi)
      cr.close_path ()

      cr.set_source_rgba (0.0, 0.0, 0.0, 0.625)
      cr.fill()

      cr.translate (a.width / 2, a.height / 2)
      cr.rotate (-math.pi / 2)
      cr.scale (min (a.width / 100., a.height / 100.),
                min (a.width / 100., a.height / 100.))

      angle = self.progress * 2 * math.pi

      r = 10
      cr.set_line_width (r)
      cr.set_line_cap (cairo.LINE_CAP_ROUND)

      # the circle segment. fades out before it becomes too short
      cr.set_source_rgba (1.0, 1.0, 1.0, max (0.0, min (1.0,
                          (math.pi * 14.5 / 8 - math.pi * 1.5 / 8 - angle))))
      cr.arc (0, 0, 50 - 2.25 * r,
              angle + math.pi * 1.5 / 8, math.pi * 14.5 / 8)
      cr.stroke ()

      # the line in the middle: yellow when active.
      if self.progress > 0.001:
         cr.set_source_rgba (0.969, 0.522, 0.0, 1.0)
      else:
         cr.set_source_rgba (1.0, 1.0, 1.0, 1.0)

      cr.move_to (0, 0)
      cr.line_to (math.cos (angle) * (50 - 1.5 * r),
                  math.sin (angle) * (50 - 1.5 * r))
      cr.stroke ()

      # the pie segment showing the completion state.
      cr.set_source_rgba (1.0, 1.0, 1.0, 0.5)
      cr.move_to (0, 0)
      cr.arc (0, 0, 50 - 2.25 * r, 0, angle)
      cr.close_path ()
      cr.fill ()

      hildondesktop.HomePluginItem.do_expose_event (self, event)


   def settings_dialog (self, widget):
      dialog = gtk.Dialog ()
      dialog.set_title ('TV-B-Gone for N900')
      dialog.add_button ('Europe', 1)
      dialog.add_button ('North America', 2)
      label = gtk.Label ()
      label.set_markup ('<b>TV-B-Gone for N900</b>\n' +
                        'currently using codes for <span fgcolor="#f78500">%s</span>\n' % self.codeid +
                        '<span size="xx-small">\n</span>' +
                        '<span size="x-small">© 2010 Simon Budig, &lt;simon@budig.de&gt;\n' +
                        'Codes scanned by Limor Fried &amp; Mitch Altman\n' +
                        'for the “TV-B-Gone Kit” project.\n</span>')
      dialog.vbox.add (label)
      dialog.show_all ()
      result = dialog.run ()
      dialog.destroy ()
      if result >= 1 and result <= 2:
         if result == 1:
            self.codeid = "Europe"
         if result == 2:
            self.codeid = "North America"
         conf_client = gconf.client_get_default()
         conf_client.add_dir (GCONFPATH, gconf.CLIENT_PRELOAD_NONE)
         try:
            conf_client.set_string (GCONFPATH + "/codeid", self.codeid)
         except Exception:
            pass

         self.codes = TVBGoneCodes [self.codeid]



   def send_code (self):
      if self.index < len (self.codes):
         try:
            if not self.lircdev:
               self.lircdev = file ("/dev/lirc0", "w")
        
            code = self.codes[self.index]
        
            # set up carrier and duty cycle. Since the driver does not seem
            # to support continuous output, we try to use the fastest possible
            # carrier frequency and a duty cycle as "on" as possible.
            if code[0]:
               # ioctl: LIRC_SET_SEND_CARRIER
               fcntl.ioctl (self.lircdev, 0x40046913,
                            struct.pack ("<i", code[0]))
               # ioctl: LIRC_SET_SEND_DUTY_CYCLE
               fcntl.ioctl (self.lircdev, 0x40046915,
                            struct.pack ("<i", 50))
            else:
               # try to simulate no carrier
               fcntl.ioctl (self.lircdev, 0x40046913,
                            struct.pack ("<i", 500000))
               fcntl.ioctl (self.lircdev, 0x40046915,
                            struct.pack ("<i", 1))
        
            # the driver only supports up to 256 pulse/gap timings and needs
            # an odd number of times (starting/ending with pulse).
            # there os one bigger code in the set which would need breaking up
            # here (not yet done).
            if (len (code[1]) < 128):
               data = "".join ([struct.pack ("<ii", *code[2][ord(i) - ord ('0')]) for i in code[1]])
               # last gap must not be written
               self.lircdev.write (data[:-4])
               self.lircdev.flush ()
        
            self.index += 1
            self.progress = float (self.index) / len (self.codes)
            self.timeout = gobject.timeout_add (200, self.send_code)

         except IOError:
            hildon.hildon_banner_show_information (self, "", "troubles accessing IR device.")
            self.index = 0
            self.progress = 0.0
            self.timeout = None
      else:
         hildon.hildon_banner_show_information (self, "", "Sent %d standby codes in %.1fs." % (self.index, time.time() - self.start_time))
         self.index = 0
         self.progress = 0.0
         if self.lircdev:
            self.lircdev.close ()
            self.lircdev = None
         self.timeout = None

      self.queue_draw ()
      return False


   def button_release_event (self, widget, event):
      if self.timeout:
         gobject.source_remove (self.timeout)
         self.timeout = None
         hildon.hildon_banner_show_information (self, "", "Sent %d standby codes in %.1fs." % (self.index, time.time() - self.start_time))
         self.index = 0
         self.progress = 0.0
         if self.lircdev:
            self.lircdev.close ()
            self.lircdev = None
         self.queue_draw ()
      else:
         self.index = 0
         self.progress = 0.0
         self.start_time = time.time ()
         self.send_code ()

      return False



hd_plugin_type = TVBGone

if __name__ == '__main__':
   gobject.type_register (hd_plugin_type)
   obj = gobject.new (hd_plugin_type,
                      plugin_id = hd_plugin_type.__class__.__name__)
   obj.show_all()
   gtk.main()

