/*
 * TurnOver - try to turn over all the chess pieces
 * Copyright (C) 2010 Xizhi Zhu
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef SETTINGDIALOG_H
#define SETTINGDIALOG_H


#include <QtGui/QDialog>
#include <QtGui/QLineEdit>
#include <QtGui/QPushButton>


class SettingDialog: public QDialog
{
    Q_OBJECT

public:
    SettingDialog(QWidget *parent = NULL);

    void show(int column, int row);

private Q_SLOTS:
    void changeSetting();

Q_SIGNALS:
    void settingChanged(int column, int row);

private:
    int column;
    int row;
    QLineEdit *columnEdit;
    QLineEdit *rowEdit;
    QPushButton *okButton;
    QPushButton *cancelButton;
};


#endif // SETTINGDIALOG_H
