import Qt 4.7

Item {
    id: wrapper
	Loading {  width: 128; height: 128; visible: wrapper.state == 'loading'
		anchors.centerIn: parent;
	}
	
	function startupFunction() {        
		var db = openDatabaseSync("tsinaclient", "1.0", "新浪微博数据库", 1000000);
		db.transaction(
		function(tx) {
		 // Create the database if it doesn't already exist
		 tx.executeSql('CREATE TABLE IF NOT EXISTS passwds(username varchar(255) PRIMARY KEY ASC, password varchar(255),token varchar(255),secret varchar(255),user_id Long)');
		 var rs = tx.executeSql('select * from passwds');
		 if(rs.rows.length==1){
			nameIn.text=rs.rows.item(0).username;
			passIn.text=rs.rows.item(0).password;
		 }		 
	 });
     }

    Component.onCompleted: startupFunction();

	 
    Column {
        anchors.centerIn: parent
        spacing: 20
        Column{
            spacing: 4
            Text {
                text: "用户名:"
                font.pixelSize: 16; font.bold: true; color: "white"; style: Text.Raised; styleColor: "black"
                horizontalAlignment: Qt.AlignRight
            }
            Item {
                width: 220
                height: 28
                BorderImage { source: "images/lineedit.sci"; anchors.fill: parent }
                TextInput{
                    id: nameIn
					text: ''
                    width: parent.width - 8
                    anchors.centerIn: parent
                    maximumLength:21
                    font.pixelSize: 16;
                    font.bold: true
                    color: "#151515"; selectionColor: "green"
                    KeyNavigation.tab: passIn
                    focus: true
                }
            }
        }
        Column{
            spacing: 4
            Text {
                text: "密码:"
                font.pixelSize: 16; font.bold: true; color: "white"; style: Text.Raised; styleColor: "black"
                horizontalAlignment: Qt.AlignRight
            }
            Item {
                width: 220
               height: 28
                BorderImage { source: "images/lineedit.sci"; anchors.fill: parent }
                TextInput{
                    id: passIn
                    width: parent.width - 8
                    anchors.centerIn: parent
                    maximumLength:21
                    echoMode: TextInput.Password
                    font.pixelSize: 16;
                    font.bold: true
                    color: "#151515"; selectionColor: "green"
                    KeyNavigation.tab: login
                    KeyNavigation.backtab: nameIn
					text: ''
                    onAccepted: login.doLogin();
                }
            }
        }
        Row{
            spacing: 10
            Button {
                width: 100
                height: 32
                id: login
                keyUsing: true;
                function doLogin(){
                    wrapper.state = "loading"
                    oauth.username=nameIn.text;
                    oauth.password=passIn.text;					
                    oauth.beginAuthentication();
                }

                text: "登录"                
                KeyNavigation.backtab: passIn
                Keys.onReturnPressed: login.doLogin();
                Keys.onEnterPressed: login.doLogin();
                Keys.onSelectPressed: login.doLogin();
                Keys.onSpacePressed: login.doLogin();
                onClicked: login.doLogin();
            }

        }
    }
}
