

/*
 * This file is part of Maemo 5 Office UI for KOffice
 *
 * Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: Afaque Hussain <afaquejam@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include"TextTranslate.h"

TextTranslate::TextTranslate()
{

    sourceText = new QTextEdit;
    translatedText = new QTextEdit;

    httpRequest =new QHttp;

    /*  Setting the Window title of Ouput Dialog */

    outputDialog = new QDialog(this);
    outputDialog->setWindowTitle("Translation");

    /* Initializing Language codes */
    sourceLanguageCode="";
    targetLanguageCode="";


    /* Language Selection Combo Boxes */
    QComboBox *sourceLanguageBox =new QComboBox;
    QComboBox *targetLanguageBox =new QComboBox;


    /* String Lists to hold the Language Names */
    QStringList sourceLanguageList;
    QStringList targetLanguageList;

    /* Translate Button */
    QPushButton *translateButton = new QPushButton;
    translateButton->setText("Translate");

    /* Select Document Button */
    QPushButton *selectDocument = new QPushButton;
    selectDocument->setText("Select a Document to Translate.");

    /* Setting up String lists with languages */
    sourceLanguageList<<"From"<<"AFRIKAANS"<<"ALBANIAN"<<"AMHARIC"<<"ARABIC"<<"ARMENIAN"<<"AZERBAIJANI"<<"BASQUE"<<"BELARUSIAN"<<"BENGALI"<<"BIHARI"<<"BRETON"<<"BULGARIAN"<<"BURMESE"<<"CATALAN"<<"CHEROKEE"<<"CHINESE"<<"CHINESE_SIMPLIFIED"<<"CHINESE_TRADITIONAL"<<"CORSICAN"<<"CROATIAN"<<"CZECH"<<"DANISH"<<"DHIVEHI"<<"DUTCH"<<"ENGLISH"<<"ESPERANTO"<<"ESTONIAN"<<"FAROESE"<<"FILIPINO"<<"FINNISH"<<"FRENCH"<<"FRISIAN"<<"GALICIAN"<<"GEORGIAN"<<"GERMAN"<<"GREEK"<<"GUJARATI"<<"HAITIAN_CREOLE"<<"HEBREW"<<"HINDI"<<"HUNGARIAN"<<"ICELANDIC"<<"INDONESIAN"<<"INUKTITUT"<<"IRISH"<<"ITALIAN"<<"JAPANESE"<<"JAVANESE"<<"KANNADA"<<"KAZAKH"<<"KHMER"<<"KOREAN"<<"KURDISH"<<"KYRGYZ"<<"LAO"<<"LATIN"<<"LATVIAN"<<"LITHUANIAN"<<"LUXEMBOURGISH"<<"MACEDONIAN"<<"MALAY"<<"MALAYALAM"<<"MALTESE"<<"MAORI"<<"MARATHI"<<"MONGOLIAN"<<"NEPALI"<<"NORWEGIAN"<<"OCCITAN"<<"ORIYA"<<"PASHTO"<<"PERSIAN"<<"POLISH"<<"PORTUGUESE"<<"PORTUGUESE_PORTUGAL"<<"PUNJABI"<<"QUECHUA"<<"ROMANIAN"<<"RUSSIAN"<<"SANSKRIT"<<"SCOTS_GAELIC"<<"SERBIAN"<<"SINDHI"<<"SINHALESE"<<"SLOVAK"<<"SLOVENIAN"<<"SPANISH"<<"SUNDANESE"<<"SWAHILI"<<"SWEDISH"<<"SYRIAC"<<"TAJIK"<<"TAMIL"<<"TATAR"<<"TELUGU"<<"THAI"<<"TIBETAN"<<"TONGA"<<"TURKISH"<<"UKRAINIAN"<<"URDU"<<"UZBEK"<<"UIGHUR"<<"VIETNAMESE"<<"WELSH"<<"YIDDISH"<<"YORUBA";
    targetLanguageList<<"To"<<"AFRIKAANS"<<"ALBANIAN"<<"AMHARIC"<<"ARABIC"<<"ARMENIAN"<<"AZERBAIJANI"<<"BASQUE"<<"BELARUSIAN"<<"BENGALI"<<"BIHARI"<<"BRETON"<<"BULGARIAN"<<"BURMESE"<<"CATALAN"<<"CHEROKEE"<<"CHINESE"<<"CHINESE_SIMPLIFIED"<<"CHINESE_TRADITIONAL"<<"CORSICAN"<<"CROATIAN"<<"CZECH"<<"DANISH"<<"DHIVEHI"<<"DUTCH"<<"ENGLISH"<<"ESPERANTO"<<"ESTONIAN"<<"FAROESE"<<"FILIPINO"<<"FINNISH"<<"FRENCH"<<"FRISIAN"<<"GALICIAN"<<"GEORGIAN"<<"GERMAN"<<"GREEK"<<"GUJARATI"<<"HAITIAN_CREOLE"<<"HEBREW"<<"HINDI"<<"HUNGARIAN"<<"ICELANDIC"<<"INDONESIAN"<<"INUKTITUT"<<"IRISH"<<"ITALIAN"<<"JAPANESE"<<"JAVANESE"<<"KANNADA"<<"KAZAKH"<<"KHMER"<<"KOREAN"<<"KURDISH"<<"KYRGYZ"<<"LAO"<<"LATIN"<<"LATVIAN"<<"LITHUANIAN"<<"LUXEMBOURGISH"<<"MACEDONIAN"<<"MALAY"<<"MALAYALAM"<<"MALTESE"<<"MAORI"<<"MARATHI"<<"MONGOLIAN"<<"NEPALI"<<"NORWEGIAN"<<"OCCITAN"<<"ORIYA"<<"PASHTO"<<"PERSIAN"<<"POLISH"<<"PORTUGUESE"<<"PORTUGUESE_PORTUGAL"<<"PUNJABI"<<"QUECHUA"<<"ROMANIAN"<<"RUSSIAN"<<"SANSKRIT"<<"SCOTS_GAELIC"<<"SERBIAN"<<"SINDHI"<<"SINHALESE"<<"SLOVAK"<<"SLOVENIAN"<<"SPANISH"<<"SUNDANESE"<<"SWAHILI"<<"SWEDISH"<<"SYRIAC"<<"TAJIK"<<"TAMIL"<<"TATAR"<<"TELUGU"<<"THAI"<<"TIBETAN"<<"TONGA"<<"TURKISH"<<"UKRAINIAN"<<"URDU"<<"UZBEK"<<"UIGHUR"<<"VIETNAMESE"<<"WELSH"<<"YIDDISH"<<"YORUBA";

    /* Providing the Set up String Lists to Language selection ComboBoxes */
    sourceLanguageBox->addItems(sourceLanguageList);
    targetLanguageBox->addItems(targetLanguageList);


    /* Setting up the Layout of Input Dialog */
    QHBoxLayout *buttonLayout = new QHBoxLayout;
    buttonLayout->addWidget(sourceLanguageBox);
    buttonLayout->addWidget(targetLanguageBox);
    buttonLayout->addWidget(translateButton);

    QVBoxLayout *inputDialogLayout = new QVBoxLayout;
    inputDialogLayout->addWidget(selectDocument);
    inputDialogLayout->addWidget(sourceText);
    inputDialogLayout->addLayout(buttonLayout);
    this->setLayout(inputDialogLayout);


    /* Opening File Selection Dialog */
    QObject::connect(selectDocument,SIGNAL(clicked()),this,SLOT(loadDocument()));

    /* Initialize the google  Language codes when user selects the languages.  */
    QObject::connect(sourceLanguageBox,SIGNAL(activated(int)),this,SLOT(sourceLanguageSelect(int)));
    QObject::connect(targetLanguageBox,SIGNAL(activated(int)),this,SLOT(targetLanguageSelect(int)));

    /* Translate as soon as the user releases the translate button */
    QObject::connect(translateButton,SIGNAL(released()),this,SLOT(doTranslation()));
    QObject::connect(httpRequest,SIGNAL(done(bool)),this ,SLOT(showTranslation()));



    /* Setting up the Layout of Output Dialog */
    QVBoxLayout *outputDialogLayout = new QVBoxLayout;
    outputDialogLayout->addWidget(translatedText);
    translatedText->setFixedWidth(770);
    outputDialog->setLayout(outputDialogLayout);

}

void TextTranslate::loadDocument()
{


    filePath =QFileDialog::getOpenFileName(this,"Select Document..","/home/user/MyDocs/Documents"," Text Documents ( *.txt )");

    QByteArray bufferOne;

     /* Reading contents of the file */
      QFile text(filePath);
            text.open(QIODevice::ReadOnly | QIODevice::Text);

                while (!text.atEnd()) {
                     QByteArray bufferTwo = text.readLine();
                     bufferOne.append(bufferTwo);
                 }


                 /* Determine the encoding of the document */
                 QTextCodec *codec = QTextCodec::codecForHtml(bufferOne);
                 QString string = codec->toUnicode(bufferOne);

                 sourceText->setPlainText(QString(bufferOne));
}

void TextTranslate::sourceLanguageSelect(int index)
{
    /* Initializing the source google language code  */
    switch (index) {

    case 0  : sourceLanguageCode=" ";
              break;
    case 1  : sourceLanguageCode="af";
              break;
    case 2  : sourceLanguageCode="sq";
              break;
    case 3  : sourceLanguageCode="am";
              break;
    case 4  : sourceLanguageCode="ar";
              break;
    case 5  : sourceLanguageCode="hy";
              break;
    case 6  : sourceLanguageCode="az";
              break;
    case 7  : sourceLanguageCode="eu";
              break;
    case 8  : sourceLanguageCode="be";
              break;
    case 9  : sourceLanguageCode="bn";
              break;
    case 10  : sourceLanguageCode="bh";
              break;
    case 11  : sourceLanguageCode="br";
              break;
    case 12  : sourceLanguageCode="bg";
              break;
    case 13  : sourceLanguageCode="my";
              break;
    case 14  : sourceLanguageCode=" ca";
              break;
    case 15  : sourceLanguageCode="chr";
              break;
    case 16  : sourceLanguageCode="zh";
              break;
    case 17  : sourceLanguageCode="zh-CN";
              break;
    case 18  : sourceLanguageCode="zh-TW";
              break;
    case 19  : sourceLanguageCode="co";
              break;
    case 20  : sourceLanguageCode="hr";
              break;
    case 21  : sourceLanguageCode="cs";
              break;
    case 22  : sourceLanguageCode="da";
              break;
    case 23  : sourceLanguageCode="dv";
              break;
    case 24  : sourceLanguageCode="nl";
              break;
    case 25  : sourceLanguageCode="en";
              break;
    case 26  : sourceLanguageCode="eo";
              break;
    case 27  : sourceLanguageCode="et";
              break;
    case 28  : sourceLanguageCode="fo";
              break;
    case 29  : sourceLanguageCode="tl";
              break;
    case 30  : sourceLanguageCode="fi";
              break;
    case 31  : sourceLanguageCode="fr";
              break;
    case 32  : sourceLanguageCode="fy";
              break;
    case 33  : sourceLanguageCode="gl";
              break;
    case 34  : sourceLanguageCode="ka";
              break;
    case 35  : sourceLanguageCode="de";
              break;
    case 36  : sourceLanguageCode="el";
              break;
    case 37  : sourceLanguageCode="gu";
              break;
    case 38  : sourceLanguageCode="ht";
              break;
    case 39  : sourceLanguageCode="iw";
              break;
    case 40  : sourceLanguageCode="hi";
              break;
    case 41  : sourceLanguageCode="hu";
              break;
    case 42  : sourceLanguageCode="is";
              break;
    case 43  : sourceLanguageCode="id";
              break;
    case 44  : sourceLanguageCode="iu";
              break;
    case 45  : sourceLanguageCode="ga";
              break;
    case 46  : sourceLanguageCode="it";
              break;
    case 47  : sourceLanguageCode="ja";
              break;
    case 48  : sourceLanguageCode="jw";
              break;
    case 49  : sourceLanguageCode="kn";
              break;
    case 50  : sourceLanguageCode="kk";
              break;
    case 51  : sourceLanguageCode="km";
              break;
    case 52  : sourceLanguageCode="ko";
              break;
    case 53  : sourceLanguageCode="ku";
              break;
    case 54  : sourceLanguageCode="ky";
              break;
    case 55  : sourceLanguageCode="lo";
              break;
    case 56  : sourceLanguageCode="la";
              break;
    case 57  : sourceLanguageCode="lv";
              break;
    case 58  : sourceLanguageCode="lt";
              break;
    case 59  : sourceLanguageCode="lb";
              break;
    case 60  : sourceLanguageCode="mk";
              break;
    case 61  : sourceLanguageCode="ms";
              break;
    case 62  : sourceLanguageCode="ml";
              break;
    case 63  : sourceLanguageCode="mt";
              break;
    case 64  : sourceLanguageCode="mi";
              break;
    case 65  : sourceLanguageCode="mr";
              break;
    case 66  : sourceLanguageCode="mn";
              break;
    case 67  : sourceLanguageCode="ne";
              break;
    case 68  : sourceLanguageCode="no";
              break;
    case 69  : sourceLanguageCode="oc";
              break;
    case 70  : sourceLanguageCode="or";
              break;
    case 71  : sourceLanguageCode="ps";
              break;
    case 72  : sourceLanguageCode="fa";
              break;
    case 73  : sourceLanguageCode="pl";
              break;
    case 74  : sourceLanguageCode="pt";
              break;
    case 75  : sourceLanguageCode="pt-PT";
              break;
    case 76  : sourceLanguageCode="pa";
              break;
    case 77  : sourceLanguageCode="qu";
              break;
    case 78  : sourceLanguageCode="ro";
              break;
    case 79  : sourceLanguageCode="ru";
              break;
    case 80  : sourceLanguageCode="sa";
              break;
    case 81  : sourceLanguageCode="gd";
              break;
    case 82  : sourceLanguageCode="sr";
              break;
    case 83  : sourceLanguageCode="sd";
              break;
    case 84  : sourceLanguageCode="si";
              break;
    case 85  : sourceLanguageCode="sk";
              break;
    case 86  : sourceLanguageCode="sl";
              break;
    case 87  : sourceLanguageCode="es";
              break;
    case 88  : sourceLanguageCode="su";
              break;
    case 89  : sourceLanguageCode="sw";
              break;
    case 90  : sourceLanguageCode="sv";
              break;
    case 91  : sourceLanguageCode="syr";
              break;
    case 92  : sourceLanguageCode="tg";
              break;
    case 93  : sourceLanguageCode="ta";
              break;
    case 94  : sourceLanguageCode="tt";
              break;
    case 95  : sourceLanguageCode="te";
              break;
    case 96  : sourceLanguageCode="th";
              break;
    case 97  : sourceLanguageCode="bo";
              break;
    case 98  : sourceLanguageCode="to";
              break;
    case 99  : sourceLanguageCode="tr";
              break;
    case 100  : sourceLanguageCode="uk";
              break;
    case 101  : sourceLanguageCode="ur";
              break;
    case 102  : sourceLanguageCode="uz";
              break;
    case 103  : sourceLanguageCode="ug";
              break;
    case 104  : sourceLanguageCode="vi";
              break;
    case 105  : sourceLanguageCode="cy";
              break;
    case 106  : sourceLanguageCode="yi";
              break;
    case 107  : sourceLanguageCode="yo";
              break;

     }
}


void TextTranslate::targetLanguageSelect(int index)
{
     /* Initializing the Target google language code  */
       switch (index){

       case 0  : targetLanguageCode=" ";
                 break;
       case 1  : targetLanguageCode="af";
                 break;
       case 2  : targetLanguageCode="sq";
                 break;
       case 3  : targetLanguageCode="am";
                 break;
       case 4  : targetLanguageCode="ar";
                 break;
       case 5  : targetLanguageCode="hy";
                 break;
       case 6  : targetLanguageCode="az";
                 break;
       case 7  : targetLanguageCode="eu";
                 break;
       case 8  : targetLanguageCode="be";
                 break;
       case 9  : targetLanguageCode="bn";
                 break;
       case 10  : targetLanguageCode="bh";
                 break;
       case 11  : targetLanguageCode="br";
                 break;
       case 12  : targetLanguageCode="bg";
                 break;
       case 13  : targetLanguageCode="my";
                 break;
       case 14  : targetLanguageCode=" ca";
                 break;
       case 15  : targetLanguageCode="chr";
                 break;
       case 16  : targetLanguageCode="zh";
                 break;
       case 17  : targetLanguageCode="zh-CN";
                 break;
       case 18  : targetLanguageCode="zh-TW";
                 break;
       case 19  : targetLanguageCode="co";
                 break;
       case 20  : targetLanguageCode="hr";
                 break;
       case 21  : targetLanguageCode="cs";
                 break;
       case 22  : targetLanguageCode="da";
                 break;
       case 23  : targetLanguageCode="dv";
                 break;
       case 24  : targetLanguageCode="nl";
                 break;
       case 25  : targetLanguageCode="en";
                 break;
       case 26  : targetLanguageCode="eo";
                 break;
       case 27  : targetLanguageCode="et";
                 break;
       case 28  : targetLanguageCode="fo";
                 break;
       case 29  : targetLanguageCode="tl";
                 break;
       case 30  : targetLanguageCode="fi";
                 break;
       case 31  : targetLanguageCode="fr";
                 break;
       case 32  : targetLanguageCode="fy";
                 break;
       case 33  : targetLanguageCode="gl";
                 break;
       case 34  : targetLanguageCode="ka";
                 break;
       case 35  : targetLanguageCode="de";
                 break;
       case 36  : targetLanguageCode="el";
                 break;
       case 37  : targetLanguageCode="gu";
                 break;
       case 38  : targetLanguageCode="ht";
                 break;
       case 39  : targetLanguageCode="iw";
                 break;
       case 40  : targetLanguageCode="hi";
                 break;
       case 41  : targetLanguageCode="hu";
                 break;
       case 42  : targetLanguageCode="is";
                 break;
       case 43  : targetLanguageCode="id";
                 break;
       case 44  : targetLanguageCode="iu";
                 break;
       case 45  : targetLanguageCode="ga";
                 break;
       case 46  : targetLanguageCode=" it";
                 break;
       case 47  : targetLanguageCode=" ja";
                 break;
       case 48  : targetLanguageCode="jw";
                 break;
       case 49  : targetLanguageCode="kn";
                 break;
       case 50  : targetLanguageCode="kk";
                 break;
       case 51  : targetLanguageCode="km";
                 break;
       case 52  : targetLanguageCode="ko";
                 break;
       case 53  : targetLanguageCode="ku";
                 break;
       case 54  : targetLanguageCode="ky";
                 break;
       case 55  : targetLanguageCode="lo";
                 break;
       case 56  : targetLanguageCode="la";
                 break;
       case 57  : targetLanguageCode="lv";
                 break;
       case 58  : targetLanguageCode="lt";
                 break;
       case 59  : targetLanguageCode="lb";
                 break;
       case 60  : targetLanguageCode="mk";
                 break;
       case 61  : targetLanguageCode="ms";
                 break;
       case 62  : targetLanguageCode="ml";
                 break;
       case 63  : targetLanguageCode="mt";
                 break;
       case 64  : targetLanguageCode="mi";
                 break;
       case 65  : targetLanguageCode="mr";
                 break;
       case 66  : targetLanguageCode="mn";
                 break;
       case 67  : targetLanguageCode="ne";
                 break;
       case 68  : targetLanguageCode="no";
                 break;
       case 69  : targetLanguageCode="oc";
                 break;
       case 70  : targetLanguageCode="or";
                 break;
       case 71  : targetLanguageCode="ps";
                 break;
       case 72  : targetLanguageCode="fa";
                 break;
       case 73  : targetLanguageCode="pl";
                 break;
       case 74  : targetLanguageCode="pt";
                 break;
       case 75  : targetLanguageCode="pt-PT";
                 break;
       case 76  : targetLanguageCode="pa";
                 break;
       case 77  : targetLanguageCode="qu";
                 break;
       case 78  : targetLanguageCode="ro";
                 break;
       case 79  : targetLanguageCode="ru";
                 break;
       case 80  : targetLanguageCode="sa";
                 break;
       case 81  : targetLanguageCode="gd";
                 break;
       case 82  : targetLanguageCode="sr";
                 break;
       case 83  : targetLanguageCode="sd";
                 break;
       case 84  : targetLanguageCode="si";
                 break;
       case 85  : targetLanguageCode="sk";
                 break;
       case 86  : targetLanguageCode="sl";
                 break;
       case 87  : targetLanguageCode="es";
                 break;
       case 88  : targetLanguageCode="su";
                 break;
       case 89  : targetLanguageCode="sw";
                 break;
       case 90  : targetLanguageCode="sv";
                 break;
       case 91  : targetLanguageCode="syr";
                 break;
       case 92  : targetLanguageCode="tg";
                 break;
       case 93  : targetLanguageCode="ta";
                 break;
       case 94  : targetLanguageCode="tt";
                 break;
       case 95  : targetLanguageCode="te";
                 break;
       case 96  : targetLanguageCode="th";
                 break;
       case 97  : targetLanguageCode="bo";
                 break;
       case 98  : targetLanguageCode="to";
                 break;
       case 99  : targetLanguageCode="tr";
                 break;
       case 100  : targetLanguageCode="uk";
                 break;
       case 101  : targetLanguageCode="ur";
                 break;
       case 102  : targetLanguageCode="uz";
                 break;
       case 103  : targetLanguageCode="ug";
                 break;
       case 104  : targetLanguageCode="vi";
                 break;
       case 105  : targetLanguageCode="cy";
                 break;
       case 106  : targetLanguageCode="yi";
                 break;
       case 107  : targetLanguageCode="yo";
                 break;
       }
}



void TextTranslate::doTranslation()
{

    /* Get the Text Entered by User  */
    QString inputText;
    inputText=sourceText->toPlainText();

    /* If user doesn't enter any Text  */
    if(inputText.isEmpty())
    {
        QMaemo5InformationBox::information(this, "Please Enter Text.",1000);
        return;
    }


    /* If user doesn't select the target Language  */
    if(targetLanguageCode.isEmpty())
    {
        QMaemo5InformationBox::information(this, "Please Select the Target Language.",1000);
        return;
    }

    /* If user selects same source and target Language  */
    if(sourceLanguageCode==targetLanguageCode)
    {
        QMaemo5InformationBox::information(this, "Source and Destination Languages are Same.",1000);
        return;
    }

    /* Wait message while translation from google server arrive. Duration of this message is 1000ms  */
    QMaemo5InformationBox::information(this, "Translating.Please Wait.......",1000);


     /*Preparing for HTTP request  */
     QString url = QString("/translate_a/t?client=t&sl="+sourceLanguageCode+"&tl="+targetLanguageCode );

     QHttpRequestHeader header = QHttpRequestHeader("POST", url, 1, 1);
     header.setValue("Host", "www.google.com");
     header.setValue("User-Agent", "Mozilla/5.0");
     header.setValue("Accept-Encoding", "deflate");
     header.setContentLength(inputText.length());
     header.setValue("Connection", "Close");

     QByteArray queryString("text=");
     queryString.append( inputText.toUtf8() );


     httpRequest->setHost("www.google.com");

     /* Request for Translation */
     httpRequest->request(header,queryString);


}

void TextTranslate::showTranslation()
{


    /* Receive the Traslated Text */
    QString reply;
    reply = reply.fromUtf8( httpRequest->readAll() );

    /* Parsing the reply */
    reply.replace(QRegExp(",.*"),"");
    reply.replace("[[[","");
    reply.replace("\"","");


     /* Setting source for the QTextEdit */
     translatedText->setText(reply);


     /* Close InputDialog before showing Output Dialog  */

     this->hide();

     /* After Closing InputDialog, Show Output Dialog  */
     outputDialog->show();

}
