#!/usr/bin/env python

import sys
import optparse
import re
import string
import os
import time
import gtk
import commands
import hildon
import ConfigParser
import osso

# Global constants
#os.environ["SDL_VIDEO_X11_WMCLASS"]="transitioncontrol"
osso_c = osso.Context("transitioncontrol", "0.0.1", False)

config = ConfigParser.ConfigParser()
config.readfp(open('/usr/share/hildon-desktop/transitions.ini'))        
        
                
class transitioncontrol(hildon.Program):
    def __init__(self):
        global config
        hildon.Program.__init__(self)
        self.saveOn=True
        self.window = hildon.Window()
        self.window.connect("destroy", gtk.main_quit)  
        self.add_window(self.window)
        
        self.increaseAll_button = gtk.Button("All +100 ms")
        self.increaseAll_button.connect("clicked", self.increaseAll)
        
        self.decreaseAll_button = gtk.Button("All -100 ms")
        self.decreaseAll_button.connect("clicked", self.decreaseAll)
        
        
        self.restart_button = gtk.Button("Restart Desktop")
        self.restart_button.connect("clicked", self.restartDesktop)
        
        self.apply_button = gtk.Button("Apply Changes")
        self.apply_button.connect("clicked", self.applyChanges)
        
        self.textBuff = gtk.TextBuffer(None)
        self.textBuff.set_text(commands.getoutput("lsusb"))
        self.textArea = gtk.TextView(self.textBuff)
                                                                             
        pannable_area = hildon.PannableArea()        
        vbox = gtk.VBox(spacing=12)
        pannable_area.add_with_viewport(vbox)
        self.window.add(pannable_area)
        vbox.show()
        
                                                                                      
        table = gtk.Table (3, 2, False)                                                               
        table.set_col_spacings (30)                                                                   
        table.set_row_spacings (30)                                                                   
                 
        central_panel = gtk.HBox (spacing=12)                                                                                                                                                                                                              
        central_panel.pack_start (table, fill=True)                                                   
        
        hbox = gtk.HBox(False, 0)        
        
        
        #hbox.pack_start(self.increaseAll_button, True, True, 0)
        #hbox.pack_start(self.decreaseAll_button, True, True, 0)
        hbox.pack_start(self.apply_button, True, True, 0)
        #hbox.pack_start(gtk.Label ("Multiplier :"), True, True,0)
        #self.multiplier_entry = hildon.NumberEditor(1, 10)
        #hbox.pack_start(self.multiplier_entry, True, True, 0)
        #self.multiplier_entry.set_value(3)
        
        vbox.pack_start(hbox, False, True, 0)                
        hbox.show()
        self.apply_button.show()
        
        vbox.pack_start (central_panel, expand=True, fill=True)                                  
        vbox.pack_start  (gtk.Label ("* Requires restart of desktop"), expand=True, fill=True)
        vbox.pack_start  (self.restart_button, expand=True, fill=True)                                           
                                                                     
        table.attach (gtk.Label ("Blur :"),               0, 1, 0, 1, 0)
        table.attach (gtk.Label ("Task Zoom*:"),       0, 1, 1, 2, 0)
        table.attach (gtk.Label ("Task Rearrange*:"),  0, 1, 2, 3, 0)
        table.attach (gtk.Label ("App Open:"),   0, 1, 3, 4, 0)
        table.attach (gtk.Label ("Launcher In:"),       0, 1, 4, 5, 0)
        table.attach (gtk.Label ("Launcher Out:"),       0, 1, 5, 6, 0)
        table.attach (gtk.Label ("Launcher Sub In:"),  0, 1, 6, 7, 0)
        table.attach (gtk.Label ("Launcher Sub Out:"), 0, 1, 7, 8, 0)
        table.attach (gtk.Label ("App Close:"),           0, 1, 8, 9, 0)
        
        table.attach (gtk.Label ("Subview In:"),      3, 4, 0, 1, 0)
        table.attach (gtk.Label ("Subview Out:"),      3, 4, 1, 2, 0)
        table.attach (gtk.Label ("Notification In:"), 3, 4, 2, 3, 0)
        table.attach (gtk.Label ("Notification Out:"),3, 4, 3, 4, 0)        
        table.attach (gtk.Label ("Rotate %:"),          3, 4, 4, 5, 0)
        table.attach (gtk.Label ("Rotate In:"),       3, 4, 5, 6, 0)
        table.attach (gtk.Label ("Rotate Out:"),      3, 4, 6, 7, 0)
        table.attach (gtk.Label ("Blank min:"),       3, 4, 7, 8, 0)
        table.attach (gtk.Label ("Blank max:"),       3, 4, 8, 9, 0)
                                                                     
        #self.title_entry = gtk.Entry()
        self.blur_entry = hildon.NumberEditor(0, 200)
        self.blur_entry.set_value(config.getint('blur', 'duration')/10)#FIX
        
        self.taskzoom_entry = hildon.NumberEditor(0, 200)
        self.taskzoom_entry.set_value(config.getint('task_nav', 'zoom_duration')/10)#FIX
        
        self.taskfly_entry = hildon.NumberEditor(0, 200)
        self.taskfly_entry.set_value(config.getint('task_nav', 'fly_duration')/10)#FIX
        
        self.launcherStart_entry = hildon.NumberEditor(0, 200)
        self.launcherStart_entry.set_value(config.getint('launcher_launch', 'duration')/10)#FIX
        
        self.launcherIn_entry = hildon.NumberEditor(0, 200)
        self.launcherIn_entry.set_value(config.getint('launcher_in', 'duration')/10)#FIX
        
        self.launcherOut_entry = hildon.NumberEditor(0, 200)
        self.launcherOut_entry.set_value(config.getint('launcher_out', 'duration')/10)#FIX
        
        self.submenuIn_entry = hildon.NumberEditor(0, 200)
        self.submenuIn_entry.set_value(config.getint('launcher_in_sub', 'duration')/10)#FIX
        
        self.submenuOut_entry = hildon.NumberEditor(0, 200)
        self.submenuOut_entry.set_value(config.getint('launcher_out_sub', 'duration')/10)#FIX
        
        self.appClose_entry = hildon.NumberEditor(0, 200)
        self.appClose_entry.set_value(config.getint('app_close', 'duration')/10)#FIX
        
        
        
        self.subViewIn_entry = hildon.NumberEditor(0, 200)
        self.subViewIn_entry.set_value(config.getint('subview', 'duration_in')/10)#FIX
        
        self.subViewOut_entry = hildon.NumberEditor(0, 200)
        self.subViewOut_entry.set_value(config.getint('subview', 'duration_out')/10)#FIX
        
        self.notificationIn_entry = hildon.NumberEditor(0, 200)
        self.notificationIn_entry.set_value(config.getint('notification', 'duration_in')/10)#FIX
        
        self.notificationOut_entry = hildon.NumberEditor(0, 200)
        self.notificationOut_entry.set_value(config.getint('notification', 'duration_out')/10)#FIX
        
        self.rotation_entry = hildon.NumberEditor(0, 100)
        self.rotation_entry.set_value(config.getint('rotate', 'angle'))#FIX
        
        self.rotateIn_entry = hildon.NumberEditor(0, 200)
        self.rotateIn_entry.set_value(config.getint('rotate', 'duration_in')/10)#FIX
        
        self.rotateOut_entry = hildon.NumberEditor(0, 200)
        self.rotateOut_entry.set_value(config.getint('rotate', 'duration_out')/10)#FIX
        
        self.damage_entry = hildon.NumberEditor(0, 200)
        self.damage_entry.set_value(config.getint('rotate', 'damage_timeout')/10)#FIX
        
        self.damageMax_entry = hildon.NumberEditor(0, 200)
        self.damageMax_entry.set_value(config.getint('rotate', 'damage_timeout_max')/10)#FIX
        
        
        table.attach (self.blur_entry,          1, 2, 0, 1)
        table.attach (self.taskzoom_entry,      1, 2, 1, 2)
        table.attach (self.taskfly_entry,      1, 2, 2, 3)
        table.attach (self.launcherStart_entry, 1, 2, 3, 4)
        table.attach (self.launcherIn_entry,  1, 2, 4, 5)
        table.attach (self.launcherOut_entry, 1, 2, 5, 6)
        table.attach (self.submenuIn_entry,   1, 2, 6, 7)
        table.attach (self.submenuOut_entry,  1, 2, 7, 8)
        table.attach (self.appClose_entry,      1, 2, 8, 9)
        
        table.attach (self.subViewIn_entry,   4, 5, 0, 1)
        table.attach (self.subViewOut_entry,  4, 5, 1, 2)
        table.attach (self.notificationIn_entry,4, 5, 2, 3)
        table.attach (self.notificationOut_entry,4, 5, 3, 4)
        table.attach (self.rotation_entry,      4, 5, 4, 5)
        table.attach (self.rotateIn_entry,    4, 5, 5, 6)
        table.attach (self.rotateOut_entry,   4, 5, 6, 7)
        table.attach (self.damage_entry,    4, 5, 7, 8)
        table.attach (self.damageMax_entry,   4, 5, 8, 9)
        
    
    def increaseAll(self,widget):
        print "Increase All"
        self.blur_entry.set_value(self.blur_entry.get_value()+10)
        self.taskzoom_entry.set_value(self.taskzoom_entry.get_value()+10)
        self.taskfly_entry.set_value(self.taskfly_entry.get_value()+10)
        self.launcherStart_entry.set_value(self.launcherStart_entry.get_value()+10)
        self.launcherIn_entry.set_value(self.launcherIn_entry.get_value()+10)
        self.launcherOut_entry.set_value(self.launcherOut_entry.get_value()+10)
        self.submenuIn_entry.set_value(self.submenuIn_entry.get_value()+10)
        self.submenuOut_entry.set_value(self.submenuOut_entry.get_value()+10)
        self.rotateIn_entry.set_value(self.rotateIn_entry.get_value()+10)
        self.rotateOut_entry.set_value(self.rotateOut_entry.get_value()+10)
        self.appClose_entry.set_value(self.appClose_entry.get_value()+10)
        self.subViewIn_entry.set_value(self.subViewIn_entry.get_value()+10)
        self.subViewOut_entry.set_value(self.subViewOut_entry.get_value()+10)
        self.notificationIn_entry.set_value(self.notificationIn_entry.get_value()+10)
        self.notificationOut_entry.set_value(self.notificationOut_entry.get_value()+10)
        self.rotation_entry.set_value(self.rotation_entry.get_value()+10)

    def decreaseAll(self,widget):
        print "Decrease All"
        self.blur_entry.set_value(self.blur_entry.get_value()-10)
        self.taskzoom_entry.set_value(self.taskzoom_entry.get_value()-10)
        self.taskfly_entry.set_value(self.taskfly_entry.get_value()-10)
        self.launcherStart_entry.set_value(self.launcherStart_entry.get_value()-10)
        self.launcherIn_entry.set_value(self.launcherIn_entry.get_value()-10)
        self.launcherOut_entry.set_value(self.launcherOut_entry.get_value()-10)
        self.submenuIn_entry.set_value(self.submenuIn_entry.get_value()-10)
        self.submenuOut_entry.set_value(self.submenuOut_entry.get_value()-10)
        self.appClose_entry.set_value(self.appClose_entry.get_value()-10)
        self.subViewIn_entry.set_value(self.subViewIn_entry.get_value()-10)
        self.subViewOut_entry.set_value(self.subViewOut_entry.get_value()-10)
        self.notificationIn_entry.set_value(self.notificationIn_entry.get_value()-10)
        self.notificationOut_entry.set_value(self.notificationOut_entry.get_value()-10)
        self.rotation_entry.set_value(self.rotation_entry.get_value()-10)
        self.rotateIn_entry.set_value(self.rotateIn_entry.get_value()-10)
        self.rotateOut_entry.set_value(self.rotateOut_entry.get_value()-10)
        
    
    def restartDesktop(self, widget):
        self.applyChanges(widget)
        devs = commands.getoutput("killall hildon-desktop")
        sdevs = devs.rsplit('\n')
                        
    def applyChanges(self, widget):
            global config
            print "Applying changes"
            #multiplier=self.multiplier_entry.get_value()*3
            multiplier=10        
            config.set('blur', 'duration', str(self.blur_entry.get_value()*multiplier))
            config.set('task_nav', 'zoom_duration', str(self.taskzoom_entry.get_value()*multiplier))
            config.set('task_nav', 'fly_duration', str(self.taskfly_entry.get_value()*multiplier))
            config.set('launcher_launch', 'duration', str(self.launcherStart_entry.get_value()*multiplier))
            config.set('launcher_in', 'duration', str(self.launcherIn_entry.get_value()*multiplier))
            config.set('launcher_out', 'duration', str(self.launcherOut_entry.get_value()*multiplier))
            config.set('launcher_in_sub', 'duration', str(self.submenuIn_entry.get_value()*multiplier))
            config.set('launcher_out_sub', 'duration', str(self.submenuOut_entry.get_value()*multiplier))
            config.set('rotate', 'duration_in', str(self.rotateIn_entry.get_value()*multiplier))
            config.set('rotate', 'duration_out', str(self.rotateOut_entry.get_value()*multiplier))
            config.set('rotate', 'angle', str(self.rotation_entry.get_value()))
            config.set('rotate', 'damage_timeout', str(self.damage_entry.get_value()*multiplier))
            config.set('rotate', 'damage_timeout_max', str(self.damageMax_entry.get_value()*multiplier))
            config.set('app_close', 'duration', str(self.appClose_entry.get_value()*multiplier))
            config.set('subview', 'duration_in', str(self.subViewIn_entry.get_value()*multiplier))
            config.set('subview', 'duration_out', str(self.subViewOut_entry.get_value()*multiplier))
            config.set('notification', 'duration_in', str(self.subViewIn_entry.get_value()*multiplier))
            config.set('notification', 'duration_out', str(self.subViewOut_entry.get_value()*multiplier))
            
            config.write(open('/usr/share/hildon-desktop/transitions.ini', 'wb'))
        
    def run(self):     
        self.window.show_all()
        gtk.main() 

if __name__ == "__main__":
      
    app = transitioncontrol()
    app.run()         
