# -*- coding: utf-8 -*-
from PyQt4.QtGui import QDialog, QPushButton, QGridLayout, QLabel

class PushDialog(QDialog):
    Cancel = 0
    Forget = 1
    Save = 2
    Push = 3
    PushAndUnlock = 4
    def __init__(self, remote=True, parent=None):
        QDialog.__init__(self, parent)
        self.setWindowTitle("Confirmation")
        self.resize(600,200)

        if remote:
            buttonPushAndUnlock = QPushButton("Push and &unlock", parent=self)
            buttonPush = QPushButton("&Push", parent=self)
        else:
            buttonSave = QPushButton("&Save", parent=self)
        buttonForget = QPushButton("&Forget changes", parent=self)
        buttonCancel = QPushButton("&Continue translating", parent=self)

        label = QLabel("The file has been modifed. Do you want to save changes"+
        " locally or push them back to server?", parent=self)
        label.setWordWrap(True)

        layout = QGridLayout(self)
        
        if remote:
            layout.addWidget(label, 0, 0, 1, 2)
            layout.addWidget(buttonPushAndUnlock, 1, 0)
            layout.addWidget(buttonPush, 2, 0)
            layout.addWidget(buttonForget, 1, 1)
            layout.addWidget(buttonCancel, 2, 1)
        else:
            layout.addWidget(label, 0, 0, 1, 3)
            layout.addWidget(buttonSave, 1, 0)
            layout.addWidget(buttonForget, 1, 1)
            layout.addWidget(buttonCancel, 1, 2)
        
        if remote:
            buttonPush.clicked.connect(lambda : self.done(self.Push))
            buttonPushAndUnlock.clicked.connect(lambda : self.done(self.PushAndUnlock))
        else:
            buttonSave.clicked.connect(lambda : self.done(self.Save))

        buttonForget.clicked.connect(lambda : self.done(self.Forget))
        buttonCancel.clicked.connect(lambda : self.done(self.Cancel))
        self.setLayout(layout)