# -*- coding: utf-8 -*-

from PyQt4.QtGui import QDialog, QComboBox, QLineEdit, QPushButton, \
    QGridLayout, QLabel
from PyQt4.Qt import Qt

class ServerAddDialog(QDialog):
    KNOWN_TRANSIFEX_SERVERS = [
        ("http://www.transifex.net", "Transifex.net"),
        ("http://translate.moblin.org", "Translate Moblin"),
        ("https://translate.fedoraproject.org", "Translate Fedora")
    ]

    @classmethod
    def get(self, default=None):
        d = ServerAddDialog()
        s = None
        if d.exec_():
            s = str(d.hostname.currentText()), str(d.username.text()), \
                str(d.password.text())
        del d
        return s

    def __init__(self, parent=None):
        QDialog.__init__(self, parent)
        self.setWindowTitle("Add Transifex instance")
        self.resize(300,0)
        self.hostname = QComboBox()
        for hostname, title in self.KNOWN_TRANSIFEX_SERVERS:
            self.hostname.addItem(hostname, hostname)
        self.hostname.setEditable(True)
        self.hostname.setCompleter(None)

        self.username = QLineEdit()
        self.username.setCompleter(None)

        self.password = QLineEdit()
        self.password.setCompleter(None)
        self.password.setEchoMode(QLineEdit.Password)

        self.button = QPushButton("Add")
        self.button.clicked.connect(self.accept)

        layout = QGridLayout()
        layout.addWidget(QLabel("Hostname"), 0, 0)
        layout.addWidget(QLabel("Username"), 1, 0)
        layout.addWidget(QLabel("Password"), 2, 0)
        layout.addWidget(self.hostname, 0, 1)
        layout.addWidget(self.username, 1, 1)
        layout.addWidget(self.password, 2, 1)
        layout.addWidget(self.button, 2, 2)

        self.setLayout(layout)
        self.setModal(Qt.WindowModal)