/*
 * This file is part of TpSession
 *
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * Contact Kate Alhola  kate.alholanokia.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef TPSESSIONACCOUNT_H
#define TPSESSIONACCOUNT_H

#include <TelepathyQt4/Types>
#include <TelepathyQt4/Account>
#include <TelepathyQt4/Types>
#include <TelepathyQt4/PendingChannelRequest>
#include <TelepathyQt4/ChannelRequest>
#include <TelepathyQt4/PendingChannel>
#include <TelepathyQt4/PendingContacts>
#include <TelepathyQt4/Channel>
#include <TelepathyQt4/TextChannel>
#include <TelepathyQt4/AccountManager>
#include <TelepathyQt4/PendingReady>
#include <TelepathyQt4/ContactManager>

#include <QString>
#include <QVector>

#include "tpsessionchannel.h"

class TpSessionAccount:public QObject
{

    Q_OBJECT
public:
  TpSessionAccount(Tp::AccountManagerPtr am,const QString &objectPath);
  void makeContactFromAddress(QString address);
  void sendMessageToAddress(QString address,QString message);
  Tp::ContactPtr getContactFromAddress(QString address);
  void addOutgoingChannel(const Tp::ContactPtr &contact);
  void addOutgoingChannel(QString address);
  TpSessionChannel *getChannelFromPeerAddress(QString id);
signals:
  void accountReady(TpSessionAccount *);
  void channelReady(TpSessionAccount *);
  void messageReceived(const Tp::ReceivedMessage &,TpSessionAccount *);
  void messageSent(const Tp::Message &,TpSessionAccount *);
  void newChannel(TpSessionAccount *,QString,QString,const Tp::ChannelDetails &);

private slots:
  void onReady(Tp::PendingOperation *op);
  void onOutgoingChannelReady(TpSessionChannel *ch);
  void onContactsConnectionReady(Tp::PendingOperation *op);
  void onNewContactRetrieved(Tp::PendingOperation *op);
  void onMessageReceived(const Tp::ReceivedMessage &,TpSessionChannel *);
  void onMessageSent(const Tp::Message &,Tp::MessageSendingFlags, const QString &);
  void onNewChannels(const Tp::ChannelDetailsList&);
public:
  bool ready;
  QString reqContact;
  QString reqMessage;
  Tp::AccountPtr mAcc;
  Tp::Account *acc;
  Tp::ConnectionPtr contactsConn;
  QSet<Tp::ContactPtr> myContacts;
  QSet<TpSessionChannel *> myChannels;
};

#endif // TPSESSIONACCOUNT_H
