/*
 * This file is part of TpSession
 *
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * Contact Kate Alhola  kate.alholanokia.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "tpsessionaccount.h"
#include <TelepathyQt4/Message>

TpSessionAccount::TpSessionAccount(Tp::AccountManagerPtr am,const QString &objectPath):
        mAcc(Tp::Account::create(am->dbusConnection(),am->busName(), objectPath))

{
  connect(mAcc->becomeReady(),SIGNAL(finished(Tp::PendingOperation *)),SLOT(onReady(Tp::PendingOperation *)));
  ready=false;
  qDebug() << "TpSessionAccount::TpSessionAccount objectPath=" << objectPath;
};


void TpSessionAccount::onReady(Tp::PendingOperation *op)
{

    acc = mAcc.data();
    qDebug() << "TpSessionAccount::onReady cmName=" << acc->cmName() << "haveConnection=" <<
        (acc->haveConnection()? ( acc->connection()->isReady() ? "Ready":"notReady"):"no");

    if(acc->haveConnection()) {
#if 0
            if (acc->connection()->interfaces().contains(TELEPATHY_INTERFACE_CONNECTION_INTERFACE_CAPABILITIES)) {
            Tp::CapabilityPair capability = {
                TELEPATHY_INTERFACE_CHANNEL_TYPE_TEXT
                };
                qDebug() << "TpSessionAccount::onConnectionConnected: advertising capabilities";
                acc->connection()->capabilitiesInterface()->AdvertiseCapabilities(
                    Tp::CapabilityPairList() << capability,
                    QStringList());
            }
#endif
            connect(acc->connection()->becomeReady(Tp::Connection::FeatureRoster | Tp::Connection::FeatureSelfContact ),
                SIGNAL(finished(Tp::PendingOperation *)),
                SLOT(onContactsConnectionReady(Tp::PendingOperation *)));
         if (acc->connection()->isReady() && acc->connection()->interfaces().contains(TELEPATHY_INTERFACE_CONNECTION_INTERFACE_REQUESTS)) {
            qDebug() << "TpSessionAccount::onReady: connecting to Connection.Interface.NewChannels";
            connect(acc->connection()->requestsInterface(),
                SIGNAL(NewChannels(const Tp::ChannelDetailsList&)),
                SLOT(onNewChannels(const Tp::ChannelDetailsList&)));
        }
     }
         else { // If there is no connection, we are ready now, else we are ready when contacts connection is ready
            ready=true;
            emit accountReady(this);
        }
     }

void TpSessionAccount::onContactsConnectionReady(Tp::PendingOperation *op)
{
    if (op->isError()) {
        qWarning() << "Connection cannot become ready" << acc->cmName();
        return;
    }

    if (acc->connection()->interfaces().contains(TELEPATHY_INTERFACE_CONNECTION_INTERFACE_REQUESTS)) {
            qDebug() << "TpSessionAccount::onContactsConectionReady: connecting to Connection.Interface.NewChannels";
            connect(acc->connection()->requestsInterface(),
                SIGNAL(NewChannels(const Tp::ChannelDetailsList&)),
                SLOT(onNewChannels(const Tp::ChannelDetailsList&)));
        } else qDebug() << "TpSessionAccount::onContactsConnectionReady: does NO have CONNECTION_INTERFACE_REQUESTS";
    Tp::PendingReady *pr = qobject_cast<Tp::PendingReady *>(op);
     contactsConn = Tp::ConnectionPtr(qobject_cast<Tp::Connection *>(pr->object()));
#if 0
    connect(contactsConn->contactManager(),
            SIGNAL(presencePublicationRequested(const Tp::Contacts &)),
            SLOT(onPresencePublicationRequested(const Tp::Contacts &)));
#endif
    qDebug() << "TpSessionAccount::onContactsConnectionReady "<< acc->cmName() ;
    //    RosterItem *item;
    bool exists;
    myContacts=contactsConn->contactManager()->allKnownContacts();
    foreach (const Tp::ContactPtr &contact, myContacts) {
        qDebug() << "id=" <<contact->id() << " alias=" << contact->alias() << " presence=" << contact->presenceStatus()  ;
        if(contact->id()==reqContact) {
            addOutgoingChannel(contact);
            reqContact="";
        }
    };
    if(!reqContact.isEmpty() ) makeContactFromAddress(reqContact);
    ready=true;
    emit accountReady(this);
}

Tp::ContactPtr TpSessionAccount::getContactFromAddress(QString id)
{
    Tp::ContactPtr p;
    foreach (const Tp::ContactPtr &contact, myContacts) {
    if(contact->id()==reqContact) return p=contact;
    }
    return p;
}

TpSessionChannel* TpSessionAccount::getChannelFromPeerAddress(QString id)
{
  TpSessionChannel* p=NULL;
    foreach (TpSessionChannel* channel, myChannels) {
    if(channel->peerId()==id) return p=channel;
    }
    return p;
}

void TpSessionAccount::makeContactFromAddress(QString address)
{
     reqContact=address;  // When we get retrieved signal, we check if it is this one
     Tp::PendingContacts *pc=contactsConn->contactManager()->contactsForIdentifiers(QStringList(address));
     connect(pc,SIGNAL(finished(Tp::PendingOperation *)),SLOT(onNewContactRetrieved(Tp::PendingOperation *)));
}

void TpSessionAccount::onNewContactRetrieved(Tp::PendingOperation *op)
{
    Tp::PendingContacts *pcontacts = qobject_cast<Tp::PendingContacts *>(op);
    QList<Tp::ContactPtr> contacts = pcontacts->contacts();
    QString username = pcontacts->identifiers().first();
    if (contacts.size() != 1 || !contacts.first()) {
        qDebug() << "Unable to add contact " <<reqContact;
        return;
    }

    Tp::ContactPtr contact = contacts.first();
    qDebug() << "TpSessionAccount::onContactRetrieved" << reqContact;
    if(!reqContact.isEmpty()) addOutgoingChannel(contacts.first());
}

void TpSessionAccount::sendMessageToAddress(QString address,QString message)
{
    Tp::ContactPtr p;
    TpSessionChannel* channel=getChannelFromPeerAddress(address);
    if(channel)
        channel->sendMessage(message); // We have already channel
    else {
        reqMessage=message;
        p=getContactFromAddress(address); // Do we have contact ready ?
        if(p.isNull())  // If not, create it
            makeContactFromAddress(address); // Create and after created, send
        else
            addOutgoingChannel(p); // Create channel and when ready, send
    };
}

void TpSessionAccount::addOutgoingChannel(const Tp::ContactPtr &contact)
{


    qDebug() << "TpSessionAccount::addOutgoingChannel";

     TpSessionChannel* newChannel=new TpSessionChannel(contact->manager()->connection(),contact);
     connect(newChannel,SIGNAL(messageReceived(const Tp::ReceivedMessage &,TpSessionChannel *)),
             SLOT(onMessageReceived(const Tp::ReceivedMessage &,TpSessionChannel *)));
     connect(newChannel,SIGNAL(channelReady(TpSessionChannel *)),
            SLOT(onOutgoingChannelReady(TpSessionChannel*)));
     myChannels+=newChannel;

}

void TpSessionAccount::onOutgoingChannelReady(TpSessionChannel *ch)
{
 qDebug() << "TpSessionAccoiunt::onOutgoingChannelReady";
 emit channelReady(this);
 if(!reqMessage.isEmpty()) ch->sendMessage(reqMessage);
 reqMessage.clear();
}


void TpSessionAccount::onMessageSent(const Tp::Message &msg,Tp::MessageSendingFlags, const QString &flags)
{
    qDebug() << "TpSessionAccount::onMessageSent";
};

void TpSessionAccount::onMessageReceived(const Tp::ReceivedMessage &msg,TpSessionChannel *ch)
{
    qDebug() << "TpSessionAccount::onMessageReceived " << msg.text();
    emit messageReceived(msg,this);
};

void TpSessionAccount::onNewChannels(const Tp::ChannelDetailsList &channels)
{

    Tp::TextChannelPtr myIngoingTextChannel;
    qDebug() << "TpSessionAccount::onNewChannels";
    foreach (const Tp::ChannelDetails &details, channels) {
        QString channelType = details.properties.value(QLatin1String(TELEPATHY_INTERFACE_CHANNEL ".ChannelType")).toString();
        bool requested = details.properties.value(QLatin1String(TELEPATHY_INTERFACE_CHANNEL ".Requested")).toBool();
        qDebug() << " channelType:" << channelType;
        qDebug() << " requested  :" << requested;

        if (channelType == TELEPATHY_INTERFACE_CHANNEL_TYPE_TEXT && !requested) {

        myIngoingTextChannel = Tp::TextChannel::create(acc->connection(),details.channel.path(),details.properties);
        qDebug() << "TpSessionAccount::onNewChannels path=" <<"path " << myIngoingTextChannel->objectPath();

     TpSessionChannel* newChannel=new TpSessionChannel( myIngoingTextChannel);
     connect(newChannel,SIGNAL(messageReceived(const Tp::ReceivedMessage &,TpSessionChannel *)),
             SLOT(onMessageReceived(const Tp::ReceivedMessage &,TpSessionChannel *)));
     myChannels+=newChannel;
     }
    }
}
