#include <QtGui/QApplication>
#include <QtSql>
QSqlDatabase db;
QString base_path;
#include "mainwindow.h"



MainWindow *w;
int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    QCoreApplication::setApplicationName("TPlayer");
    QCoreApplication::setApplicationVersion("0.0.2beta");

QString langPath;
#ifdef Q_WS_MAEMO_5
base_path="/home/user/";
langPath = "/opt/tplayer/lang/";
#else
#ifdef Q_OS_WIN32
base_path=qApp->applicationDirPath()+"/";
langPath = base_path+"/lang/";
#else
#ifdef Q_WS_S60
base_path="/data/tplayer/";
langPath = base_path+"/lang/";
#else
base_path="/usr/share/tplayer/";
langPath = base_path+"/lang/";
#endif
#endif
#endif

QString lang = QLocale::languageToString(QLocale::system().language()).toLower().trimmed();
qDebug(QString("Starting TPlayer with %1 locale").arg(lang).toAscii());

//if (QFile::exists(langPath + lang + ".qm"))
//{
QTranslator translator;
translator.load(langPath + lang + ".qm");
app.installTranslator(&translator);
//}

db = QSqlDatabase::addDatabase("QSQLITE");
db.setDatabaseName(base_path+"tplayer-list");

if(!db.open()){
    QMessageBox::critical(0, QObject::tr("Database Error"),db.lastError().text());
    qApp->quit();
}

QStringList dbtables = db.tables(QSql::Tables);

  if (!dbtables.contains("tracks",Qt::CaseInsensitive)) {

 QSqlQuery sql = QSqlQuery(db);
 sql.exec(
              "create table tracks ( "
              "  path char(255) not null unique, "
              "  title char(255) , "
              "  artist char(255) , "
              "  genre char(255) , "
              "  album char(255) , "
              "  year char(255)  )" );
}

 if (!dbtables.contains( "settings",Qt::CaseInsensitive)) {

 QSqlQuery sql = QSqlQuery(db);
 sql.exec(
              "create table settings ( "
              "  parameter char(255) not null unique, "
              "  value char(255) , "
              "  custom1 char(255) , "
              "  custom2 char(255)  )" );
}

 if (!dbtables.contains( "equalizer",Qt::CaseInsensitive)) {

  QSqlQuery sql = QSqlQuery(db);
  sql.exec(
               "create table equalizer ( "
               "  name char(255) not null unique, "
               "  eq1 char(4) , "
               "  eq2 char(4) , "
               "  eq3 char(4) , "
               "  eq4 char(4) , "
               "  eq5 char(4) , "
               "  eq6 char(4) , "
               "  eq7 char(4) , "
               "  eq8 char(4) , "
               "  eq9 char(4) , "
               " eq10 char(4) ) " );
  db.exec("INSERT INTO `equalizer` (name,eq1,eq2,eq3,eq4,eq5,eq6,eq7,eq8,eq9,eq10) "
      "VALUES ('Default','0','0','0','0','0','0','0','0','0','0')");
      }
 // for next revision
/*
if (!dbtables.contains( "iradio",Qt::CaseInsensitive)) {

 QSqlQuery sql = QSqlQuery(db);
 sql.exec(
              "create table iradio ( "
              "  url char(255) not null unique, "
              "  title char(255) , "
              "  genre char(255) , "
              "  bitrate char(255) , "
              "  language char(255)  )" );
}*/



 w=new MainWindow();

 if (!QDBusConnection::sessionBus().isConnected()) {
     qWarning("Cannot connect to the D-Bus session bus.");
     exit(1);
 }

 if (!QDBusConnection::sessionBus().registerService("org.freedesktop.tplayer")) {
     qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
         message()));
     exit(2);
 }



 if (!QDBusConnection::sessionBus().registerObject("/org/freedesktop/tplayer", w,
                                                   QDBusConnection::ExportAllContents)) {
     qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
         message()));
     exit(3);
 }



#ifndef Q_WS_MAEMO_5
    w->show();
    w->resize(800,460);
    w->move(0,0);
#else
    w->showFullScreen();
#endif
//

    return app.exec();

}


QString get_setting(QString set){
    QString ret_val="";
    QString sql="SELECT * FROM `settings` WHERE `parameter`='"+set+"'";
    QSqlQuery query(sql);
    int fieldNo = query.record().indexOf("value");
         while (query.next()) {
             ret_val = query.value(fieldNo).toString();
         }

    return ret_val;
}


void set_setting(QString set,QString value){

    QString sql="DELETE FROM `settings` WHERE `parameter`='"+set+"'";
    db.commit();
    db.exec(sql);
    sql="INSERT INTO `settings` (parameter,value,custom1,custom2) "
        "VALUES ('"+set+"','"+value.replace("'","''")+"','','')";

    if(!db.exec(sql).isValid())
   qDebug(db.lastError().text().toAscii());
db.commit();
}
