#ifndef MAINWINDOWACTIONS_H
#define MAINWINDOWACTIONS_H

#include <QAction>

class QMenu;
class QObject;
class QToolBar;

class MainWindowActions
{
public:
    MainWindowActions(QObject* parent, bool, bool);
    void setupMenus (QMenu* fileMenu, QMenu* aboutMenu);
    void setupContextAndAddMenu (QMenu* contextMenu, QMenu* addMenu, QObject* parent);
    void setupToolbar (QToolBar*);
    void playingState ();
    void pausedState ();
    void stoppedState ();
    void repeatToggle (bool);
    void shuffleToggle (bool);
    void setVolumeCheck (bool val) { volumeAction->setChecked(val);  }
    bool isVolumeChecked() const {  return volumeAction->isChecked(); }
    void triggerPause () { pauseAction->trigger (); }
    void triggerPlay () { playAction->trigger (); }
    void controlsToggled (bool);
private:
    QAction *playAction;
    QAction *pauseAction;
    QAction *stopAction;
    QAction *repeatAction;
    QAction *shuffleAction;
    QAction *volumeAction;
    QAction *volumeAddedAction;
    QAction *nextAction;
    QAction *previousAction;
    QAction *upAction;
    QAction *downAction;
    QAction *delAction;
    QAction *addAction;
    QAction *addFilesAction;
    QAction *addFoldersAction;
    QAction *addUrlAction;
    QAction *savePlaylistAction;
    QAction *loadPlaylistAction;
    QAction *clearPlaylistAction;
    QAction *exitAction;
    QAction *aboutAction;
    QAction *aboutQtAction;
    QAction *removeSelected;
    QAction *removeAllButSelected;
    QAction *enqueueAction;
    QAction *enqueueActionButton;
    QAction *optionAction;
    QAction *equalizerAction;
    QAction *toggleControls;
    QAction *addMenuAddFile;
    QAction *addMenuAddUrl;
    QAction *addMenuAddFolder;
};

#endif // MAINWINDOWACTIONS_H
