#ifndef PLAYLISTMODEL_H
#define PLAYLISTMODEL_H

#include "playlistlist.h"
#include <QAbstractListModel>

using namespace QtUbuntuOne;

class PlaylistRoles : public QObject
{
    Q_OBJECT

    Q_ENUMS(Role)

public:
    enum Role {
        IdRole = Qt::UserRole + 1,
        NameRole,
        UrlRole,
        SongCountRole
    };
};

class PlaylistModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(QList<Playlist*> playlists
               READ playlists)

public:
    explicit PlaylistModel(QObject *parent = 0);
    ~PlaylistModel();

#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    int rowCount(const QModelIndex &parent = QModelIndex()) const;

    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, int role) const;

    bool setData(const QModelIndex &index, const QVariant &value, int role);
    Q_INVOKABLE bool setData(int row, const QVariant &value, int role);

    QMap<int, QVariant> itemData(const QModelIndex &index) const;
    Q_INVOKABLE QMap<int, QVariant> itemData(int row) const;

    Playlist* get(const QModelIndex &index) const;
    Q_INVOKABLE Playlist* get(int row) const;

    bool loading() const;

    QList<Playlist*> playlists() const;

public slots:
    void getPlaylists();

    void reload();
    void clear();

private:
    void setLoading(bool loading);

    void appendPlaylist(Playlist *playlist);
    void appendPlaylists(QList<Playlist*> playlists);

    void insertPlaylist(int i, Playlist *playlist);
    void insertPlaylists(int i, QList<Playlist*> playlists);

    void removePlaylist(int i);
    void removePlaylists(int i, int count);

private slots:
    void addPlaylists(PlaylistList *list);

signals:
    void countChanged(int count);
    void loadingChanged(bool loading);

private:
    QList<Playlist*> m_list;

    bool m_loading;

    QHash<int, QByteArray> m_roleNames;
};

#endif // PLAYLISTMODEL_H
