#ifndef VALUESELECTOR_H
#define VALUESELECTOR_H

#include <QMaemo5ValueButton>

class QMaemo5ListPickSelector;
class SelectionModel;

class ValueSelector : public QMaemo5ValueButton
{
    Q_OBJECT

public:
    explicit ValueSelector(const QString &text, QWidget *parent = 0);
    ~ValueSelector();

    SelectionModel* model() const;
    virtual void setModel(SelectionModel *model);
    
    QVariant currentValue();
    virtual void setValue(const QVariant &value);

protected slots:
    virtual void onSelected();

signals:
    void valueChanged(const QVariant &value);

protected:
    SelectionModel *m_model;
    QMaemo5ListPickSelector *m_selector;
};

#endif // VALUESELECTOR_H
