#include "playlistdelegate.h"
#include "../shared/playlistmodel.h"
#include <QPainter>
#include <QMaemo5Style>

PlaylistDelegate::PlaylistDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void PlaylistDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect textRect = option.rect;
    textRect.setTopLeft(QPoint(textRect.left() + 8, textRect.top() + 8));
    textRect.setHeight(32);
    textRect.setRight(textRect.right() - 8);

    painter->drawText(textRect, Qt::AlignTop | Qt::TextSingleLine, index.data(PlaylistRoles::NameRole).toString());

    textRect.moveTop(textRect.bottom());

    QFont smallFont;
    smallFont.setPixelSize(20);

    painter->setFont(smallFont);
    painter->setPen(QMaemo5Style::standardColor("SecondaryTextColor"));
    painter->drawText(textRect, Qt::AlignBottom | Qt::TextSingleLine, tr("%1 songs").arg(index.data(PlaylistRoles::SongCountRole).toInt()));
    painter->restore();
}

QSize PlaylistDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 80);
}
