#ifndef LISTVIEW_H
#define LISTVIEW_H

#include <QListView>
#include <QMouseEvent>

class QAbstractKineticScroller;

class ListView : public QListView
{
    Q_OBJECT

public:
    explicit ListView(QWidget *parent = 0);

    bool monitorScrolling() const;
    bool isScrolling() const;

public slots:
    void setRootIndex(const QModelIndex &index);
    void positionAtBeginning();
    void positionAtEnd();
    void setMonitorScrolling(bool monitor);

private:
    void keyPressEvent(QKeyEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

private slots:
    void setScrollRange(int minimum, int maximum);
    void onScrollPositionChanged(int position);

signals:
    void scrollingStarted();
    void scrollingStopped();
    void rootIndexChanged(const QModelIndex &index);
    void atEnd();

private:
    QAbstractKineticScroller *m_kineticScroller;
    QTimer *m_scrollTimer;

    int m_minimum;
    int m_maximum;

    bool m_monitor;
};

#endif // LISTVIEW_H
