#ifndef SESSION_H
#define SESSION_H

#include "settings.h"
#include "database.h"
#include "ubuntuone.h"
#include "filemodel.h"
#include "transferlistmodel.h"
#include "transferworker.h"
#include <QProgressDialog>

class Session : public QObject
{
    Q_OBJECT

public:
    explicit Session(QObject *parent = 0);
    ~Session();
    inline Settings* settings() const { return m_settings; }
    inline Database* database() const { return m_database; }
    inline UbuntuOne* ubuntu() const { return m_ubuntu; }
    inline FileModel* fileManager() const { return m_fileModel; }
    inline TransferListModel* transferManager() const { return m_transferModel; }
    inline TransferWorker* transferWorker() const { return m_transferWorker; }
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }
    QWidget* currentWindow() const;

public slots:
    void showInfoBanner(const QString &message);
    void showNoteBanner(const QString &message);
    void showProgressDialog(const QString &message, int numberOfOperations);
    void toggleBusy(bool busy) const;
    void addWindowToStack(QWidget *window);
    void removeWindowFromStack(QObject *window);
    void unwindWindowStack();
    
private:
    Settings *m_settings;
    Database *m_database;
    UbuntuOne *m_ubuntu;
    FileModel *m_fileModel;
    TransferListModel *m_transferModel;
    TransferWorker *m_transferWorker;
    QNetworkAccessManager *m_nam;
    QProgressDialog *m_progressDialog;
    QList<QWidget*> m_windowStack;
};

#endif // SESSION_H
