#include "fileswindow.h"
#include "utils.h"
#include <QtGui>
#include <QSettings>
#include <QTranslator>

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    app.setApplicationName("toBuntu");
    app.setApplicationVersion(Utils::versionNumberString());

    QSettings settings("Marxian", "toBuntu");
    settings.beginGroup("System");
    QString lang = settings.value("language").toString();
    settings.endGroup();

    QTranslator translator;
    translator.load(QString("/opt/tobuntu/translations/tobuntu_") + lang);
    app.installTranslator(&translator);

    FilesWindow window;
    window.show();

    return app.exec();
}
