#include "filenamedialog.h"

FileNameDialog::FileNameDialog(const QString &hint, const QString &name, QWidget *parent) :
    AbstractDialog(parent),
    m_hintLabel(new QLabel(hint, this)),
    m_nameEdit(new QLineEdit(name, this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_doneButton(m_buttonBox->addButton(tr("Done"), QDialogButtonBox::AcceptRole)),
    m_grid(new QGridLayout(this))
{
    connect(m_nameEdit, SIGNAL(textChanged(QString)), this, SLOT(onFileNameChanged(QString)));
    connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(accept()));

    onOrientationChanged();
    onFileNameChanged(m_nameEdit->text());
}

void FileNameDialog::setLandscapeLayout() {
    setFixedHeight(150);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_hintLabel, 0, 0);
        m_grid->addWidget(m_nameEdit, 1, 0);
        m_grid->addWidget(m_buttonBox, 1, 1);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 1);
    }
}

void FileNameDialog::setPortraitLayout() {
    setFixedHeight(220);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_hintLabel, 0, 0);
        m_grid->addWidget(m_nameEdit, 1, 0);
        m_grid->addWidget(m_buttonBox, 2, 0);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 2, 0);
    }
}

void FileNameDialog::onFileNameChanged(const QString &name) {
    m_doneButton->setEnabled(!name.isEmpty());
}

void FileNameDialog::accept() {
    emit fileNameChosen(m_nameEdit->text());
    AbstractDialog::accept();
}
